/*
 ** Copyright 2004-2009 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 **            Pierre Chifflier <chifflier@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <QtGui>

#include "preferences.h"
#include "preferences.moc"
#include "editbox.h"

#include <ui_prefs.h>

NuAppPreferences::NuAppPreferences() : QDialog(NULL, Qt::Dialog)
{
	ui = new Ui::AppPreferences();
	ui->setupUi(this);
	load_preferences();
	createDialog();
}

void NuAppPreferences::createDialog()
{
	// Set initial values *before* connecting slots, or you will go in
	// an infinite loop
	setCertificateButtons();

	connect(ui->cert_verify_remote, SIGNAL(stateChanged(int)), this, SLOT(switch_verify_remote(int)));
	connect(ui->cert_use_client_cert, SIGNAL(stateChanged(int)), this, SLOT(switch_use_client_cert(int)));
	connect(ui->ca_open, SIGNAL(pressed()), this, SLOT(popup_open_ca()));
	connect(ui->cert_open, SIGNAL(pressed()), this, SLOT(popup_open_cert()));
	connect(ui->key_open, SIGNAL(pressed()), this, SLOT(popup_open_key()));
	connect(ui->crl_open, SIGNAL(pressed()), this, SLOT(popup_open_crl()));
	connect(this, SIGNAL(accepted()), this, SLOT(save_preferences()));

	QIcon icon = QIcon(":/images/nuapplet2-running.png");
	setWindowIcon(icon);
}

void NuAppPreferences::setCertificateButtons()
{
	bool cert_verify_remote = (ui->cert_verify_remote->checkState() == Qt::Checked);
	if (cert_verify_remote) {
		ui->ca_label->setEnabled(true);
		ui->ca_path->setEnabled(true);
		ui->ca_open->setEnabled(true);
		ui->crl_label->setEnabled(true);
		ui->crl_path->setEnabled(true);
		ui->crl_open->setEnabled(true);
		ui->cert_check_fqdn->setEnabled(true);
	} else {
		ui->ca_label->setEnabled(false);
		ui->ca_path->setEnabled(false);
		ui->ca_open->setEnabled(false);
		ui->crl_label->setEnabled(false);
		ui->crl_path->setEnabled(false);
		ui->crl_open->setEnabled(false);
		ui->cert_check_fqdn->setEnabled(false);
	}

	bool cert_use_client_cert = (ui->cert_use_client_cert->checkState() == Qt::Checked);
	if (cert_use_client_cert) {
		ui->cert_label->setEnabled(true);
		ui->cert_path->setEnabled(true);
		ui->cert_open->setEnabled(true);
		ui->key_label->setEnabled(true);
		ui->key_path->setEnabled(true);
		ui->key_open->setEnabled(true);
		ui->cert_auth_by_cert->setEnabled(true);
	} else {
		ui->cert_label->setEnabled(false);
		ui->cert_path->setEnabled(false);
		ui->cert_open->setEnabled(false);
		ui->key_label->setEnabled(false);
		ui->key_path->setEnabled(false);
		ui->key_open->setEnabled(false);
		ui->cert_auth_by_cert->setEnabled(false);
	}
}

void NuAppPreferences::show()
{
	load_preferences();
	setCertificateButtons();
	QDialog::show();
}

void NuAppPreferences::load_preferences()
{
	QString str;

	settings.sync();
	ui->hostname->setText(settings.value("hostname").toString());
	ui->port->setText(settings.value("port").toString());

	bool cert_verify_remote = settings.value("cert_verify_remote").toBool();
	ui->cert_verify_remote->setCheckState(cert_verify_remote ? Qt::Checked : Qt::Unchecked);

	bool cert_check_fqdn = settings.value("cert_check_fqdn").toBool();
	ui->cert_check_fqdn->setCheckState(cert_check_fqdn ? Qt::Checked : Qt::Unchecked);

	bool cert_use_client_cert = settings.value("cert_use_client_cert").toBool();
	ui->cert_use_client_cert->setCheckState(cert_use_client_cert ? Qt::Checked : Qt::Unchecked);

	bool cert_auth_by_cert = settings.value("cert_auth_by_cert").toBool();
	ui->cert_auth_by_cert->setCheckState(cert_auth_by_cert ? Qt::Checked : Qt::Unchecked);

	str = settings.value("ca").toString();
	ui->ca_path->setText(str);

	str = settings.value("cert").toString();
	ui->cert_path->setText(str);

	str = settings.value("key").toString();
	ui->key_path->setText(str);

	str = settings.value("crl").toString();
	ui->crl_path->setText(str);

	settings.sync();
}

void NuAppPreferences::switch_use_client_cert(int state)
{
	setCertificateButtons();
}

void NuAppPreferences::switch_verify_remote(int state)
{
	setCertificateButtons();
}

void NuAppPreferences::save_preferences()
{
	settings.setValue("hostname", ui->hostname->text());
	settings.setValue("port", ui->port->text());
	bool cert_verify_remote = (ui->cert_verify_remote->checkState() == Qt::Checked);
	settings.setValue("cert_verify_remote", cert_verify_remote);
	bool cert_check_fqdn = (ui->cert_check_fqdn->checkState() == Qt::Checked);
	settings.setValue("cert_check_fqdn", cert_check_fqdn);
	settings.setValue("ca", ui->ca_path->text());
	settings.setValue("crl", ui->crl_path->text());

	settings.setValue("cert_use_client_cert", ui->cert_use_client_cert->checkState() == Qt::Checked);
	settings.setValue("key", ui->key_path->text());
	settings.setValue("cert", ui->cert_path->text());
	settings.setValue("cert_auth_by_cert", ui->cert_auth_by_cert->checkState() == Qt::Checked);

	settings.sync();
	//accept();
}

void NuAppPreferences::popup_open_key()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select key"),
						QDir::homePath(),
						tr("Key (*.key *.pem);;All Files (*)"));
	if (fileName.length() > 0) {
		ui->key_path->setText(fileName);
	}
}

void NuAppPreferences::popup_open_cert()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select certificate"),
						QDir::homePath(),
						tr("Certficate (*.crt *.pem);;All Files (*)"));
	if (fileName.length() > 0) {
		ui->cert_path->setText(fileName);
	}
}

void NuAppPreferences::popup_open_ca()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select CA certificate"),
						QDir::homePath(),
						tr("Certificate (*.crt *.pem);;All Files (*)"));
	if (fileName.length() > 0) {
		ui->ca_path->setText(fileName);
	}
}

void NuAppPreferences::popup_open_crl()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select CRL"),
						QDir::homePath(),
						tr("CRL (*.crl *.pem);;All Files (*)"));
	if (fileName.length() > 0) {
		ui->crl_path->setText(fileName);
	}
}

