// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Extrema_FuncExtCS_HeaderFile
#define _Extrema_FuncExtCS_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Adaptor3d_CurvePtr.hxx>
#include <Adaptor3d_SurfacePtr.hxx>
#include <gp_Pnt.hxx>
#include <Standard_Real.hxx>
#include <TColStd_SequenceOfReal.hxx>
#include <Extrema_SequenceOfPOnCurv.hxx>
#include <Extrema_SequenceOfPOnSurf.hxx>
#include <Standard_Boolean.hxx>
#include <math_FunctionSetWithDerivatives.hxx>
#include <Standard_Integer.hxx>
#include <math_Vector.hxx>
class Standard_OutOfRange;
class Adaptor3d_Curve;
class Adaptor3d_Surface;
class math_Matrix;
class Extrema_POnCurv;
class Extrema_POnSurf;


//! Function to find extrema of the
//! distance between a curve and a surface.
class Extrema_FuncExtCS  : public math_FunctionSetWithDerivatives
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT Extrema_FuncExtCS();
  
  Standard_EXPORT Extrema_FuncExtCS(const Adaptor3d_Curve& C, const Adaptor3d_Surface& S);
  
  //! sets the field mysurf of the function.
  Standard_EXPORT   void Initialize (const Adaptor3d_Curve& C, const Adaptor3d_Surface& S) ;
  
  Standard_EXPORT   Standard_Integer NbVariables()  const;
  
  Standard_EXPORT   Standard_Integer NbEquations()  const;
  
  //! Calculation of Fi(U,V).
  Standard_EXPORT   Standard_Boolean Value (const math_Vector& UV, math_Vector& F) ;
  
  //! Calculation of Fi'(U,V).
  Standard_EXPORT   Standard_Boolean Derivatives (const math_Vector& UV, math_Matrix& DF) ;
  
  //! Calculation of Fi(U,V) and Fi'(U,V).
  Standard_EXPORT   Standard_Boolean Values (const math_Vector& UV, math_Vector& F, math_Matrix& DF) ;
  
  //! Save the found extremum.
  Standard_EXPORT virtual   Standard_Integer GetStateNumber() ;
  
  //! Return the number of found extrema.
  Standard_EXPORT   Standard_Integer NbExt()  const;
  
  //! Return the value of the Nth distance.
  Standard_EXPORT   Standard_Real SquareDistance (const Standard_Integer N)  const;
  
  //! Returns the Nth extremum on C.
  Standard_EXPORT  const  Extrema_POnCurv& PointOnCurve (const Standard_Integer N)  const;
  
  //! Return the Nth extremum on S.
  Standard_EXPORT  const  Extrema_POnSurf& PointOnSurface (const Standard_Integer N)  const;




protected:





private:

  
  Standard_EXPORT   Adaptor3d_SurfacePtr Bidon1()  const;
  
  Standard_EXPORT   Adaptor3d_CurvePtr Bidon2()  const;


  Adaptor3d_CurvePtr myC;
  Adaptor3d_SurfacePtr myS;
  gp_Pnt myP1;
  gp_Pnt myP2;
  Standard_Real myt;
  Standard_Real myU;
  Standard_Real myV;
  TColStd_SequenceOfReal mySqDist;
  Extrema_SequenceOfPOnCurv myPoint1;
  Extrema_SequenceOfPOnSurf myPoint2;
  Standard_Boolean myCinit;
  Standard_Boolean mySinit;


};







#endif // _Extrema_FuncExtCS_HeaderFile
