/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef OPENDRIM_DHCPCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_DHCPCONFORMSTOPROFILEACCESS_H_

#include "DHCP_Common.h"

#include "OpenDRIM_DHCPConformsToProfile.h"
#include "assocOpenDRIM_DHCPConformsToProfile.h"

int DHCP_OpenDRIM_DHCPConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_unload(string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPConformsToProfile& instance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPConformsToProfile& newInstance, const OpenDRIM_DHCPConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPConformsToProfile& instance, string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPConformsToProfile& instance, string& errorMessage);

int DHCP_OpenDRIM_DHCPConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_DHCPConformsToProfile>& OpenDRIM_DHCPConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_DHCPConformsToProfile>& OpenDRIM_DHCPConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int DHCP_OpenDRIM_DHCPConformsToProfile_populate(OpenDRIM_DHCPConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_DHCPCONFORMSTOPROFILEACCESS_H_*/
