/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_DHCPServerAccess.h"

string systemName;
const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_DNSServer";

int DHCP_OpenDRIM_DHCPServer_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPServer_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPServer_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPServer>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_DHCPServer instance;
	vector<string> ethernet_names;
	int errorCode;
	dhcp_lease lease;
	string option;
	
	errorCode=dhcp_ethernet_names(ethernet_names,errorMessage);
	
	if(errorCode!=OK)
		return OK;
	
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	
	errorCode=get_dhcp_leases(lease,"dhcp-server-identifier",option,errorMessage);
	
	if(errorCode!=OK)
		return errorCode;
	
	instance.setName(option);
	
	if(discriminant == "ei")
		CF_assert(DHCP_OpenDRIM_DHCPServer_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPServer_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPServer& instance, const char** properties, string& errorMessage) {
	_E_;
	if(instance.SystemCreationClassName == systemCreationClassName &&
		instance.SystemName == systemName &&
		instance.CreationClassName == creationClassName)
	{
		dhcp_lease lease;
		string option;
		int errorCode;
		
		errorCode=get_dhcp_leases(lease,"dhcp-server-identifier",option,errorMessage);
		
		if(errorCode!=OK)
			return ERROR;
			
			if (CF_strCmpNoCase(option,instance.Name))
			{
				CF_assert(DHCP_OpenDRIM_DHCPServer_populate(instance, errorMessage));
				return OK;
			}
		
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	else
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPServer_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPServer& newInstance, const OpenDRIM_DHCPServer& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPServer_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPServer& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPServer_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPServer& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPServer_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPServer& instance, unsigned int& returnValue, const OpenDRIM_DHCPServer_RequestStateChange_In& in, OpenDRIM_DHCPServer_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPServer_populate(OpenDRIM_DHCPServer& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] SystemName               [KEY]
	 * [X] Name                     [KEY]
	 * [X] InfoFormat
	 * [X] AccessContext
	 * [X] AccessInfo
	 * [X] ElementName
	 */
	
	instance.setAccessInfo(instance.Name);
	instance.setInfoFormat(3);
	instance.setElementName("DHCP server "+instance.Name);
	instance.setAccessContext(7);
	_L_;
	return OK;
}

