# META-INFO

Meta-information is for OpenFOAM internal use only.

Do not rely on any files or any file contents in this directory,
or even the existence of this directory.

The format, content and meaning may be changed at anytime without
notice.

The information is provided here for internal documentation purposes.

## api-info

This file and its contents are to be tracked by git.

- File content (api) generated by wmakeBuildInfo from OPENFOAM define
  in `wmake/rules/General/general`

- File content (patch) is manually generated content.


## build-info

This file is *never* to be tracked by git, but may be present in shipped
source archives.

- File content (branch, build) generated by wmakeBuildInfo from git
  information and cached from previous wmake (api)


## Content types

### api

- 4-digit year-month (YYMM) integer corresponding to the major
  release or in unusual cases an intermediate release.

- Format is year-month, as per `date +%y%m`.
  Eg, `1712` for the Dec-2017 release.


### patch

- 6-digit year-month-day (YYMMDD) integer corresponding to a patch-level
  for the given **released** API.

- Format is year-month-day, as per `date +%y%m%d`.

- The first release can have a patch value of `0` (unpatched = just
  released) or a patch value corresponding to the release date.

The patch value is only meaningful together with the api value.
However, for *development* branches, the patch level should not be
ascribed much meaning -- it can be `0` or have a value corresponding
to the last merge with a *maintenance* (*eg*, `master`) branch.


## Flow of information

Changes in the build information must be reflected in information
available in the final binaries. Conversely, it is necessary for later
distributions to have a record of the same information.

| property  | source                    | saved      |
|-----------|---------------------------|------------|
| api       | wmake/rules               | api-info   |
| patch     | manual (api-info)         | build-info |
| branch    | git                       | build-info |
| build     | git                       | build-info |


The command `wmakeBuildInfo -check` is used to determine if
the saved information needs synchronization. The command
`wmakeBuildInfo -update` preforms the synchronitzation.


## Notes

The saved information is split into two separate files. The `api-info`
contains more permanent information, whereas the `build-info` is more
transient in nature.

----
2019-01-23
