/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_IMAGEENGINE_PALETTE_H_
#define _OPENRIJN_IMAGEENGINE_PALETTE_H_

#include <OpenRijn/Export.h>
#include <OpenRijn/AbstractPalette.h>

namespace OpenRijn {
  namespace ImageEngine {
    class OPENRIJN_EXPORT Palette : public ::OpenRijn::AbstractPalette {
        GTL_NO_COPY(Palette)
      public:
        Palette();
        ~Palette();
        virtual AbstractBrush* createCircleBrush(float _size, float _hardness = 0.5) const;
      private:
        struct Private;
        Private* const d;
    };
  }
}

#endif
