/* test case 2 - DH operation - 3des/MD5 */
u_int16_t     tc2_oakleygroup  = OAKLEY_GROUP_MODP1536;
oakley_auth_t tc2_auth         = AUTH_ALGORITHM_HMAC_MD5;
oakley_hash_t tc2_hash         = OAKLEY_MD5;
enum phase1_role tc2_init      = INITIATOR;

unsigned char tc2_gi[] = {
 0xff, 0xbc, 0x6a, 0x92,  0xa6, 0xb9, 0x55, 0x9b,  
 0x05, 0xfa, 0x96, 0xa7,  0xa4, 0x35, 0x07, 0xb4,  
 0xc1, 0xe1, 0xc0, 0x86,  0x1a, 0x58, 0x71, 0xd9,  
 0xba, 0x73, 0xa1, 0x63,  0x11, 0x37, 0x88, 0xc0,  
 0xde, 0xbb, 0x39, 0x79,  0xe7, 0xff, 0x0c, 0x52,  
 0xb4, 0xce, 0x60, 0x50,  0xeb, 0x05, 0x36, 0x9e,  
 0xa4, 0x30, 0x0d, 0x2b,  0xff, 0x3b, 0x1b, 0x29,  
 0x9f, 0x3b, 0x80, 0x2c,  0xcb, 0x13, 0x31, 0x8c,  
 0x2a, 0xb9, 0xe3, 0xb5,  0x62, 0x7c, 0xb4, 0xb3,  
 0x5e, 0xb9, 0x39, 0x98,  0x20, 0x76, 0xb5, 0x7c,  
 0x05, 0x0d, 0x7b, 0x35,  0xc3, 0xc5, 0xc7, 0xcc,  
 0x8c, 0x0f, 0xea, 0xb7,  0xb6, 0x4a, 0x7d, 0x7b,  
 0x6b, 0x8f, 0x6b, 0x4d,  0xab, 0xf4, 0xac, 0x40,  
 0x6d, 0xd2, 0x01, 0x26,  0xb9, 0x0a, 0x98, 0xac,  
 0x76, 0x6e, 0xfa, 0x37,  0xa7, 0x89, 0x0c, 0x43,  
 0x94, 0xff, 0x9a, 0x77,  0x61, 0x5b, 0x58, 0xf5,  
 0x2d, 0x65, 0x1b, 0xbf,  0xa5, 0x8d, 0x2a, 0x54,  
 0x9a, 0xf8, 0xb0, 0x1a,  0xa4, 0xbc, 0xa3, 0xd7,  
 0x62, 0x42, 0x66, 0x63,  0xb1, 0x55, 0xd4, 0xeb,  
 0xda, 0x9f, 0x60, 0xa6,  0xa1, 0x35, 0x73, 0xe6,  
 0xa8, 0x88, 0x13, 0x5c,  0xdc, 0x67, 0x3d, 0xd4,  
 0x83, 0x02, 0x99, 0x03,  0xf3, 0xa9, 0x0e, 0xca,  
 0x23, 0xe1, 0xec, 0x1e,  0x27, 0x03, 0x31, 0xb2,  
 0xd0, 0x50, 0xf4, 0xf7,  0x58, 0xf4, 0x99, 0x27,  
};
unsigned int tc2_gi_len = sizeof(tc2_gi);

unsigned char tc2_gr[] = {
 0xcd, 0x30, 0xdf, 0x6e,  0xc0, 0x85, 0x44, 0x12,  
 0x53, 0x01, 0x80, 0xd8,  0x7e, 0x1a, 0xfb, 0xb3,  
 0x26, 0x79, 0x3e, 0x99,  0x56, 0xc8, 0x6a, 0x96,  
 0x25, 0x53, 0xc2, 0x77,  0xad, 0x5b, 0xab, 0x50,  
 0xf8, 0x32, 0x5a, 0xd8,  0x64, 0x0b, 0x0e, 0xfe,  
 0xa5, 0x1d, 0x6c, 0x83,  0x1f, 0xa1, 0x7c, 0xfb,  
 0x0f, 0x2e, 0x1a, 0xf4,  0xb1, 0x66, 0xa0, 0xfe,  
 0x30, 0x75, 0x12, 0xad,  0x0f, 0x81, 0xab, 0xb8,  
 0xaa, 0xfb, 0x68, 0x48,  0xec, 0x10, 0xa4, 0x97,  
 0x6c, 0x3d, 0xb1, 0x17,  0xec, 0xe1, 0xe6, 0x61,  
 0xdb, 0xbf, 0x48, 0x0c,  0x28, 0x2e, 0x3f, 0x11,  
 0x07, 0xc1, 0x86, 0x42,  0x80, 0x1e, 0xe8, 0x3f,  
 0x9e, 0x4a, 0xb9, 0xab,  0x63, 0x6f, 0x23, 0x7d,  
 0xaa, 0xf6, 0xa7, 0xaa,  0xd8, 0x22, 0x99, 0x3e,  
 0xa4, 0x1e, 0xa3, 0x31,  0xee, 0x27, 0x82, 0x0b,  
 0x93, 0xf5, 0x0b, 0x8f,  0x3f, 0x71, 0x05, 0x61,  
 0xc9, 0x25, 0x70, 0x26,  0x97, 0xba, 0x6b, 0x1e,  
 0x95, 0x3c, 0x21, 0xfb,  0xc9, 0xa7, 0x7d, 0x2b,  
 0x5f, 0x87, 0x3c, 0xfc,  0x50, 0x99, 0xe7, 0x7d,  
 0x48, 0x4c, 0xdd, 0x52,  0x66, 0x4b, 0xcf, 0x0d,  
 0xbf, 0x00, 0xca, 0xfd,  0xae, 0x6d, 0xe7, 0x14,  
 0x6d, 0x11, 0x35, 0xf6,  0x5d, 0x93, 0x5f, 0x60,  
 0xb9, 0x73, 0x0f, 0xe0,  0x49, 0x2c, 0x2a, 0xf8,  
 0xc9, 0x04, 0xf6, 0x4c,  0x59, 0x16, 0x90, 0x9d,  
};
unsigned int tc2_gr_len = sizeof(tc2_gr);

unsigned char tc2_ni[] = {
 0xb5, 0xce, 0x84, 0x19,  0x09, 0x5c, 0x6e, 0x2b,  
 0x6b, 0x62, 0xd3, 0x05,  0x53, 0x05, 0xb3, 0xc4,  
};
unsigned int tc2_ni_len = sizeof(tc2_ni);

unsigned char tc2_nr[] = {
 0x47, 0xe9, 0xf9, 0x25,  0x8c, 0xa2, 0x38, 0x58,  
 0xf6, 0x75, 0xb1, 0x66,  0xb0, 0x2c, 0xc2, 0x92,  
};
unsigned int tc2_nr_len = sizeof(tc2_nr);

unsigned char tc2_icookie[] = {
 0x75, 0x46, 0xd3, 0xd6,  0xea, 0x09, 0xf7, 0xdf,  
};
unsigned int tc2_icookie_len = sizeof(tc2_icookie);

unsigned char tc2_rcookie[] = {
 0x61, 0xa6, 0x78, 0x6a,  0x41, 0xea, 0x48, 0x06,  
};
unsigned int tc2_rcookie_len = sizeof(tc2_rcookie);

unsigned char tc2_secret[] = {
 0x17, 0x9b, 0xb3, 0x22,  0xa6, 0x77, 0x6f, 0xbc,  
 0x01, 0x4e, 0x41, 0x03,  0xf0, 0xf6, 0x2e, 0x93,  
 0xfb, 0x07, 0xd0, 0x93,  0x84, 0x57, 0xe4, 0x54,  
 0x1e, 0x64, 0x46, 0xa9,  0x34, 0x37, 0xc0, 0x9d,  
};
unsigned int tc2_secret_len = sizeof(tc2_secret);

/* output values, calculated by MCR */
unsigned char tc2_results_shared[]= {
	0xc2, 0xe9, 0x1d, 0xa2,  0x05, 0x63, 0x19, 0x6e,  
	0x34, 0x89, 0xdf, 0xd1,  0xaf, 0xa5, 0x4a, 0x51,  
	0x09, 0x4d, 0x76, 0x2e,  0xff, 0xbf, 0x39, 0xa6,  
	0x1a, 0x64, 0xf4, 0x8c,  0x8e, 0xfb, 0x0a, 0x4f,  
	0xac, 0x5a, 0xa3, 0x18,  0x01, 0xaa, 0x1a, 0xcc,  
	0x94, 0xd6, 0x91, 0x50,  0x96, 0x38, 0x16, 0x8b,  
	0xdd, 0x39, 0x19, 0xc3,  0x5e, 0x99, 0x5a, 0x92,  
	0x3d, 0xe3, 0xfa, 0x2c,  0x2d, 0x21, 0xcb, 0x15,  
	0xac, 0x7a, 0x81, 0x49,  0xab, 0x37, 0x33, 0xf7,  
	0x55, 0xa3, 0x25, 0xa0,  0x90, 0x4a, 0x87, 0xbb,  
	0xfe, 0x70, 0x71, 0x8b,  0x63, 0xba, 0xaf, 0x56,  
	0xa7, 0xb4, 0x8f, 0x54,  0xd5, 0x0d, 0x17, 0x95,  
	0x14, 0xf3, 0x09, 0x21,  0xda, 0xd6, 0x8c, 0x71,  
	0x8c, 0xd4, 0x82, 0x89,  0x06, 0xc4, 0x24, 0x75,  
	0x4b, 0x55, 0x4c, 0xd9,  0x91, 0x83, 0xce, 0xb6,  
	0xad, 0xae, 0x6a, 0x5e,  0x7d, 0xbf, 0xf9, 0xef,  
	0xae, 0x60, 0xa7, 0xb7,  0x97, 0xb6, 0x31, 0x50,  
	0x4e, 0xcc, 0x0f, 0xff,  0x17, 0xf1, 0xaa, 0x4b,  
	0x1e, 0x0c, 0x61, 0x71,  0x32, 0xd6, 0xb9, 0x79,  
	0x58, 0x61, 0xe6, 0xab,  0xf3, 0x67, 0xd8, 0x9e,  
	0x3c, 0xdb, 0x68, 0x3e,  0xff, 0x9e, 0x37, 0xea,  
	0x67, 0x70, 0x21, 0x0e,  0x07, 0xea, 0xb6, 0x2b,  
	0x72, 0x30, 0xea, 0x5d,  0x55, 0x86, 0x9a, 0x04,  
	0x86, 0xed, 0xe1, 0xc7,  0xbd, 0xee, 0x61, 0x84,  
};

unsigned char tc2_results_skeyseed[]= {
	0x35, 0x8e, 0xb1, 0x84,  0xd9, 0x02, 0x7e, 0xa2,  
	0xa3, 0xb3, 0xe6, 0x08,  0xb9, 0x2f, 0x5f, 0xbf,  
};

unsigned char tc2_results_skey_d[]= {
	0x52, 0x9a, 0x10, 0x2f,  0x28, 0xdf, 0x41, 0x78,  
	0x6e, 0xc2, 0x75, 0xe1,  0x06, 0x3b, 0xd2, 0x50,  
};

unsigned char tc2_results_skey_ai[]= {
	0x3e, 0x43, 0xb9, 0xa8,  0xf8, 0x4e, 0xb0, 0x2b,  
	0xa1, 0xbe, 0x33, 0x6f,  0x4a, 0x37, 0xda, 0x21,  
};

unsigned char tc2_results_skey_ar[]= {
	0xba, 0x4e, 0xfe, 0x1c,  0xf0, 0x0a, 0x4d, 0xb0,  
	0x22, 0x02, 0x5d, 0x4f,  0x53, 0xb9, 0x56, 0x45,  
};

unsigned char tc2_results_skey_ei[]= {
	0x50, 0xa9, 0x46, 0x72,  0x7a, 0xaf, 0xfb, 0x5d,  
	0x8f, 0x85, 0x21, 0xd4,  0x88, 0xeb, 0x84, 0xec,  
	0x72, 0x87, 0x28, 0xfe,  0xb0, 0x6a, 0x22, 0xc2,  
};

unsigned char tc2_results_skey_er[]= {
	0x83, 0xc5, 0xc2, 0x82,  0xbb, 0xf7, 0xd5, 0xb7,  
	0x7a, 0xdc, 0x9f, 0x0b,  0x1d, 0x32, 0x11, 0xcc,  
	0x90, 0x22, 0x79, 0x2c,  0x20, 0xb4, 0x93, 0xd6,  
};

unsigned char tc2_results_skey_pi[]= {
	0x18, 0x01, 0x15, 0xe0,  0x86, 0xce, 0xd3, 0x95,  
	0x6b, 0x1a, 0xb1, 0xf7,  0x7b, 0xbb, 0x6f, 0x2d,  
};

unsigned char tc2_results_skey_pr[]= {
	0xc0, 0x47, 0xbc, 0x10,  0x1f, 0xd5, 0xb0, 0xe9,  
	0xb2, 0x9f, 0x74, 0x93,  0x2a, 0x8e, 0xc4, 0x3a,  
};

void finish_dh_v2(struct state *st,
		  struct pluto_crypto_req *r)
{
	//struct pcr_skeycalc_v2 *dhv2 = &r->pcr_d.dhv2;

#define CLONEIT(X) \
    clonetochunk(st->st_##X \
		 , tc2_results_##X \
		 , sizeof(tc2_results_##X) \
		 ,   "calculated " #X "shared secret");

    CLONEIT(shared);
    CLONEIT(skey_d);
    CLONEIT(skey_ai);
    CLONEIT(skey_ar);
    CLONEIT(skey_ei);
    CLONEIT(skey_er);
    CLONEIT(skey_pi);
    CLONEIT(skey_pr);
#undef CLONEIT

    st->hidden_variables.st_skeyid_calculated = TRUE;
}
