# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 042-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53803);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 042-1 (gnuserv, xemacs21)";
 script_name(name);

 desc = "The remote host is missing an update to gnuserv, xemacs21
announced via advisory DSA 042-1.

Klaus Frank has found a vulnerability in the way gnuserv handled
remote connections.  Gnuserv is a remote control facility for Emacsen
which is available as standalone program as well as included in
XEmacs21.  Gnuserv has a buffer for which insufficient boundary checks
were made.  Unfortunately this buffer affected access control to
gnuserv which is using a MIT-MAGIC-COOCKIE based system.  It is
possible to overflow the buffer containing the cookie and foozle
cookie comparison.

Gnuserv was derived from emacsserver which is part of GNU Emacs.  It's
was reworked completely and not much is to be left over from its time
as part of GNU Emacs.  Therefore the versions of emacssserver in both
Emacs19 and Emacs20 doesn't look vulnerable to this bug, they don't
even provide a MIT-MAGIC-COOKIE based mechanism.

This could lead into a remote user issue commands under
the UID of the person running gnuserv.

We recommend you upgrade your xemacs21 and gnuserv packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20042-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 042-1 (gnuserv, xemacs21)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xemacs21-support", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21-supportel", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gnuserv", ver:"2.1alpha-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21-bin", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21-mule-canna-wnn", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21-mule", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xemacs21-nomule", ver:"21.1.10-5", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
