# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1678-1 (perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62840);
 script_cve_id("CVE-2008-5302", "CVE-2008-5303", "CVE-2005-0448", "CVE-2004-0452");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1678-1 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory DSA 1678-1.

Paul Szabo rediscovered a vulnerability in the File::Path::rmtree
function of Perl. It was possible to exploit a race condition to create
setuid binaries in a directory tree or remove arbitrary files when a
process is deleting this tree.  This issue was originally known as
CVE-2005-0448 and CVE-2004-0452, which were addressed by DSA-696-1 and
DSA-620-1. Unfortunately, they were reintroduced later.

For the stable distribution (etch), these problems have been fixed in
version 5.8.8-7etch5.

For the unstable distribution (sid), these problems have been fixed in
version 5.10.0-18 and will migrate to the testing distribution (lenny)
shortly.

We recommend that you upgrade your perl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201678-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1678-1 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.8", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.8.8-7etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
