# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1967-1 (transmission)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66658);
 script_cve_id("CVE-2010-0012");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1967-1 (transmission)");

 desc = "The remote host is missing an update to transmission
announced via advisory DSA 1967-1.

Dan Rosenberg discovered that Transmission, a lightwight client for
the Bittorrent filesharing protocol performs insufficient sanitising
of file names specified in .torrent files. This could lead to the
overwrite of local files with the privileges of the user running
Transmission if the user is tricked into opening a malicious torrent
file.

For the stable distribution (lenny), this problem has been fixed in
version 1.22-1+lenny2.

For the unstable distribution (sid), this problem has been fixed in
version 1.77-1.

We recommend that you upgrade your transmission packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201967-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1967-1 (transmission)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"transmission", ver:"1.22-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"transmission-common", ver:"1.22-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"transmission-cli", ver:"1.22-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"transmission-gtk", ver:"1.22-1+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
