# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2008-1 (typo3-src)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67032);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 2008-1 (typo3-src)");

 desc = "The remote host is missing an update to typo3-src
announced via advisory DSA 2008-1.

Several remote vulnerabilities have been discovered in the TYPO3 web
content management framework: Cross-site scripting vulnerabilities have
been discovered in both the frontend and the backend. Also, user data
could be leaked. More details can be found in the Typo3 security
advisory:
http://typo3.org/teams/security/security-bulletins/typo3-sa-2010-004/

For the stable distribution (lenny), these problems have been fixed in
version 4.2.5-1+lenny3.

For the upcoming stable distribution (squeeze) and the unstable
distribution (sid), these problems have been fixed in version 4.3.2-1.

We recommend that you upgrade your typo3-src package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202008-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2008-1 (typo3-src)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"typo3-src-4.2", ver:"4.2.5-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"typo3", ver:"4.2.5-1+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
