# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 468-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53165);
 script_cve_id("CVE-2004-0152", "CVE-2004-0153");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 468-1 (emil)";
 script_name(name);

 desc = "The remote host is missing an update to emil
announced via advisory DSA 468-1.

Ulf Harnhammar discovered a number of vulnerabilities in emil, a
filter for converting Internet mail messages.  The vulnerabilities
fall into two categories:

- CVE-2004-0152 - Buffer overflows in (1) the encode_mime function,
(2) the encode_uuencode function, (3) the decode_uuencode
function.  These bugs could allow a carefully crafted email message
to cause the execution of arbitrary code supplied with the message
when it is acted upon by emil.

- CVE-2004-0153 - Format string bugs in statements which print
various error messages.  The exploit potential of these bugs has
not been established, and is probably configuration-dependent.

For the stable distribution (woody) these problems have been fixed in
version 2.1.0-beta9-11woody1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you update your emil package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20468-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 468-1 (emil)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"emil", ver:"2.1.0-beta9-11woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
