###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache HPSBUX02262
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835005);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "02262");
  script_cve_id("CVE-2005-2090", "CVE-2006-5752", "CVE-2007-0450", "CVE-2007-0774", "CVE-2007-1355", "CVE-2007-1358", "CVE-2007-1860", "CVE-2007-1863", "CVE-2007-1887", "CVE-2007-1900", "CVE-2007-2449", "CVE-2007-2450", "CVE-2007-2756", "CVE-2007-2872", "CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386");
  script_name( "HP-UX Update for Apache HPSBUX02262");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with Apache running 
  on HP-UX. The vulnerabilities could be exploited remotely via Cross Site 
  Scripting (XSS) to execute arbitrary code. 

  Impact:
  Remote arbitrary code execution
  cross site scripting (XSS)

  Affected Software/OS:
  Apache on
  HP-UX B.11.11, B.11.23, B.11.31 running Apache 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01178795-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.59.00", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.59.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.59.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.59.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}