###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_mult_vuln_nov08_win.nasl 478 2008-11-18 13:07:26Z nov $
#
# Mozilla Thunderbird Multiple Vulnerabilities November-08 (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800059);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5012", "CVE-2008-5014", "CVE-2008-5016", "CVE-2008-5017",
                "CVE-2008-5018", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5024",
                "CVE-2008-5052");
  script_bugtraq_id(32281);
  script_name("Mozilla Thunderbird Multiple Vulnerabilities November-08 (Win)");
  desc = "

  Overview: The host is installed with Mozilla Thunderbird and is prone to
  multiple vulnerabilities.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  bypass security restrictions, spoofing attacks, sensitive information
  disclosure, and JavaScript code that can be executed with the privileges
  of the signed user.

  Impact Level: System

  Affected Software/OS:
  Thunderbird version prior to 2.0.0.18 on Windows.

  Fix: Upgrade to Thunderbird version 2.0.0.18
  http://www.mozilla.com/en-US/thunderbird/all.html

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-48.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-50.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-52.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-55.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-56.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-58.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_thunderbird_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Win/Ver");
if(!tbVer){
  exit(0);
}

# Grep for thunderbird version < 2.0.0.18
if(version_is_less(version:tbVer, test_version:"2.0.0.18")){
  security_hole(0);
}
