###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for hsqldb, openoffice.org/-amd64 vulnerabilities USN-609-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840305);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "609-1");
  script_cve_id("CVE-2007-4575", "CVE-2007-5745", "CVE-2007-5746", "CVE-2007-5747", "CVE-2008-0320");
  script_name( "Ubuntu Update for hsqldb, openoffice.org/-amd64 vulnerabilities USN-609-1");
  desc = "

  Vulnerability Insight:

  It was discovered that arbitrary Java methods were not filtered out when
  opening databases in OpenOffice.org.  If a user were tricked into running
  a specially crafted query, a remote attacker could execute arbitrary
  Java with user privileges. (CVE-2007-4575)
  
  Multiple memory overflow flaws were discovered in OpenOffice.org's
  handling of Quattro Pro, EMF, and OLE files.  If a user were tricked
  into opening a specially crafted document, a remote attacker might be
  able to execute arbitrary code with user privileges. (CVE-2007-5745,
  CVE-2007-5746, CVE-2007-5747, CVE-2008-0320)

  Affected Software/OS:
  hsqldb, openoffice.org/-amd64 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/000700.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hsqldb, openoffice.org/-amd64 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-so52", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-evolution", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java", ver:"1.8.0.2-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk-gnome", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-en-us", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-base", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-calc", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-draw", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-gnome", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-impress", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-kde", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-math", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-writer", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.0.2-2ubuntu12.6", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hsqldb-server", ver:"1.8.0.2-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java-doc", ver:"1.8.0.2-1ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libhsqldb-java-gcj", ver:"1.8.0.7-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cil", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java-doc", ver:"1.8.0.7-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java", ver:"1.8.0.7-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-en-us", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-default", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hsqldb-server", ver:"1.8.0.7-1ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"2.2.0-1ubuntu6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cil", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java-gcj", ver:"1.8.0.8-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-headless", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder", ver:"1.0.0+OOo2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-sdbc-postgresql", ver:"0.7.5+OOo2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java-doc", ver:"1.8.0.8-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libhsqldb-java", ver:"1.8.0.8-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-en-us", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-default", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"hsqldb-server", ver:"1.8.0.8-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"2.3.0-1ubuntu5.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}