###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ruby_bigdecimal_lib_dos_vuln.nasl 2953 2009-06-16 13:11:23Z jun $
#
# Ruby BigDecimal Library Denial of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900570);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1904");
  script_bugtraq_id(35278);
  script_name("Ruby BigDecimal Library Denial of Service Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with Ruby and is prone to denial of
  service  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error within the BigDecimal standard library
  when trying to convert BigDecimal objects into floating point numbers
  which leads to segmentation fault.

  Impact:
  Attackers can exploit this issue to crash an application using this library.

  Impact Level: Application

  Affected Software/OS:
  Ruby 1.8.6 to 1.8.6-p368 and 1.8.7 to 1.8.7-p172 on Linux.

  Fix: Upgrade to 1.8.6-p369 or 1.8.7-p174.
  http://www.ruby-lang.org/en/news/2009/06/09/dos-vulnerability-in-bigdecimal/

  References:
  http://secunia.com/advisories/34135
  http://www.opera.com/docs/changelogs/linux/964

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_ruby_detect_lin.nasl");
  script_require_keys("Ruby/Lin/Ver");
  exit(0);
}


include("version_func.inc");

if(!rubyVer){
  exit(0);
}

if(version_in_range(version:rubyVer, test_version:"1.8.6", test_version2:"1.8.6.p367")||
   version_in_range(version:rubyVer, test_version:"1.8.7", test_version2:"1.8.7.p172")){
  security_warning(0);
rubyVer = get_kb_item("Ruby/Lin/Ver");
}
