# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:006
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63535);
 script_cve_id("CVE-2007-6720", "CVE-2008-2364", "CVE-2008-5101", "CVE-2008-5347", "CVE-2008-5348", "CVE-2008-5349", "CVE-2008-5350", "CVE-2008-5351", "CVE-2008-5352", "CVE-2008-5353", "CVE-2008-5354", "CVE-2008-5356", "CVE-2008-5357", "CVE-2008-5358", "CVE-2008-5359", "CVE-2008-5360", "CVE-2008-6393", "CVE-2009-0037", "CVE-2009-0179", "CVE-2009-0749", "CVE-2009-0848");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Summary SUSE-SR:2009:006";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:006.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:006";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-branding-upstream", rpm:"MozillaFirefox-branding-upstream~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.6~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird", rpm:"MozillaThunderbird~2.0.0.19~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird-devel", rpm:"MozillaThunderbird-devel~2.0.0.19~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird-translations", rpm:"MozillaThunderbird-translations~2.0.0.19~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit", rpm:"PackageKit~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-devel", rpm:"PackageKit-devel~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-lang", rpm:"PackageKit-lang~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PolicyKit", rpm:"PolicyKit~0.9~13.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PolicyKit-devel", rpm:"PolicyKit-devel~0.9~13.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aaa_base", rpm:"aaa_base~11.1~10007.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acx-kmp-debug", rpm:"acx-kmp-debug~20080210_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acx-kmp-default", rpm:"acx-kmp-default~20080210_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acx-kmp-pae", rpm:"acx-kmp-pae~20080210_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acx-kmp-trace", rpm:"acx-kmp-trace~20080210_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acx-kmp-xen", rpm:"acx-kmp-xen~20080210_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aide", rpm:"aide~0.13.1~39.36.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-lang", rpm:"amarok-lang~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-libvisual", rpm:"amarok-libvisual~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-xine", rpm:"amarok-xine~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"amarok-yauap", rpm:"amarok-yauap~1.4.10~26.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"appleir-kmp-debug", rpm:"appleir-kmp-debug~1.1_2.6.27.19_3.2~114.65.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"appleir-kmp-default", rpm:"appleir-kmp-default~1.1_2.6.27.19_3.2~114.65.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"appleir-kmp-pae", rpm:"appleir-kmp-pae~1.1_2.6.27.19_3.2~114.65.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"appleir-kmp-trace", rpm:"appleir-kmp-trace~1.1_2.6.27.19_3.2~114.65.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"appleir-kmp-xen", rpm:"appleir-kmp-xen~1.1_2.6.27.19_3.2~114.65.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport", rpm:"apport~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-crashdb-opensuse", rpm:"apport-crashdb-opensuse~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-gtk", rpm:"apport-gtk~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-qt", rpm:"apport-qt~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apport-retrace", rpm:"apport-retrace~0.114~8.5.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi", rpm:"at-spi~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-devel", rpm:"at-spi-devel~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-doc", rpm:"at-spi-doc~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"at-spi-lang", rpm:"at-spi-lang~1.24.0~2.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"attr", rpm:"attr~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audacity", rpm:"audacity~1.3.5~49.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile", rpm:"audiofile~0.2.6~142.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"audiofile-devel", rpm:"audiofile-devel~0.2.6~142.19.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-debug", rpm:"aufs-kmp-debug~cvs20081020_2.6.27.19_3.2~1.32.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-default", rpm:"aufs-kmp-default~cvs20081020_2.6.27.19_3.2~1.32.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-pae", rpm:"aufs-kmp-pae~cvs20081020_2.6.27.19_3.2~1.32.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-trace", rpm:"aufs-kmp-trace~cvs20081020_2.6.27.19_3.2~1.32.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-xen", rpm:"aufs-kmp-xen~cvs20081020_2.6.27.19_3.2~1.32.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.3~82.28.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-howl-devel", rpm:"avahi-compat-howl-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-compat-mDNSResponder-devel", rpm:"avahi-compat-mDNSResponder-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"avahi-utils", rpm:"avahi-utils~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"backup-manager", rpm:"backup-manager~0.1.0~13.12.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"backup-manager-lang", rpm:"backup-manager-lang~0.1.0~13.12.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.5.0P2~18.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez", rpm:"bluez~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-alsa", rpm:"bluez-alsa~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-compat", rpm:"bluez-compat~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-devel", rpm:"bluez-devel~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-client", rpm:"boinc-client~6.2.18~2.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-client-devel", rpm:"boinc-client-devel~6.2.18~2.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-gui", rpm:"boinc-gui~6.2.18~2.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boinc-gui-lang", rpm:"boinc-gui-lang~6.2.18~2.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero", rpm:"brasero~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero-doc", rpm:"brasero-doc~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brasero-lang", rpm:"brasero-lang~0.8.3~1.18.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brocade-bfa-kmp-debug", rpm:"brocade-bfa-kmp-debug~1.1.0.2_2.6.27.19_3.2~1.7.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brocade-bfa-kmp-default", rpm:"brocade-bfa-kmp-default~1.1.0.2_2.6.27.19_3.2~1.7.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brocade-bfa-kmp-pae", rpm:"brocade-bfa-kmp-pae~1.1.0.2_2.6.27.19_3.2~1.7.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brocade-bfa-kmp-trace", rpm:"brocade-bfa-kmp-trace~1.1.0.2_2.6.27.19_3.2~1.7.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"brocade-bfa-kmp-xen", rpm:"brocade-bfa-kmp-xen~1.1.0.2_2.6.27.19_3.2~1.7.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cifs-mount", rpm:"cifs-mount~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compat-openssl097g", rpm:"compat-openssl097g~0.9.7g~146.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"conduit", rpm:"conduit~0.3.15~2.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib", rpm:"courier-authlib~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-devel", rpm:"courier-authlib-devel~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-ldap", rpm:"courier-authlib-ldap~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-mysql", rpm:"courier-authlib-mysql~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-pgsql", rpm:"courier-authlib-pgsql~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-pipe", rpm:"courier-authlib-pipe~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-userdb", rpm:"courier-authlib-userdb~0.61.0~1.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash", rpm:"crash~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-devel", rpm:"crash-devel~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-doc", rpm:"crash-doc~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"crash-sial", rpm:"crash-sial~4.0.7.4~8.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.19.0~11.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dazuko-kmp-debug", rpm:"dazuko-kmp-debug~2.3.6_2.6.27.19_3.2~1.49.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dazuko-kmp-default", rpm:"dazuko-kmp-default~2.3.6_2.6.27.19_3.2~1.49.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dazuko-kmp-pae", rpm:"dazuko-kmp-pae~2.3.6_2.6.27.19_3.2~1.49.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dazuko-kmp-trace", rpm:"dazuko-kmp-trace~2.3.6_2.6.27.19_3.2~1.49.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dazuko-kmp-xen", rpm:"dazuko-kmp-xen~2.3.6_2.6.27.19_3.2~1.49.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp", rpm:"dhcp~3.1.1~6.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-client", rpm:"dhcp-client~3.1.1~6.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-devel", rpm:"dhcp-devel~3.1.1~6.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-relay", rpm:"dhcp-relay~3.1.1~6.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcp-server", rpm:"dhcp-server~3.1.1~6.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice", rpm:"dice~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice-debug", rpm:"dice-debug~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dice-devel", rpm:"dice-devel~0.1.9~1.3.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-debug", rpm:"drbd-kmp-debug~8.2.7_2.6.27.19_3.2~1.18.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-default", rpm:"drbd-kmp-default~8.2.7_2.6.27.19_3.2~1.18.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-pae", rpm:"drbd-kmp-pae~8.2.7_2.6.27.19_3.2~1.18.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-trace", rpm:"drbd-kmp-trace~8.2.7_2.6.27.19_3.2~1.18.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-xen", rpm:"drbd-kmp-xen~8.2.7_2.6.27.19_3.2~1.18.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"eID-belgium", rpm:"eID-belgium~2.6.0~121.29.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.24.1.1~4.13.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.24.1.1~5.11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~2.24.1.1~5.11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-doc", rpm:"evolution-data-server-doc~2.24.1.1~5.11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-lang", rpm:"evolution-data-server-lang~2.24.1.1~5.11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.24.1.1~4.13.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-exchange", rpm:"evolution-exchange~2.24.1~4.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-exchange-doc", rpm:"evolution-exchange-doc~2.24.1~4.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-exchange-lang", rpm:"evolution-exchange-lang~2.24.1~4.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-lang", rpm:"evolution-lang~2.24.1.1~4.13.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.24.1.1~4.13.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~10.0.22.87~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git", rpm:"git~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-arch", rpm:"git-arch~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-core", rpm:"git-core~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-cvs", rpm:"git-cvs~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-daemon", rpm:"git-daemon~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-email", rpm:"git-email~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-svn", rpm:"git-svn~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gitk", rpm:"gitk~1.6.0.2~6.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glade3", rpm:"glade3~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glade3-lang", rpm:"glade3-lang~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc", rpm:"glibc~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-devel", rpm:"glibc-devel~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-html", rpm:"glibc-html~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-i18ndata", rpm:"glibc-i18ndata~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-info", rpm:"glibc-info~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-locale", rpm:"glibc-locale~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-obsolete", rpm:"glibc-obsolete~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-profile", rpm:"glibc-profile~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-main-menu", rpm:"gnome-main-menu~0.9.11~22.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit", rpm:"gnome-packagekit~0.3.11~2.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit-lang", rpm:"gnome-packagekit-lang~0.3.11~2.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel", rpm:"gnome-panel~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-devel", rpm:"gnome-panel-devel~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-doc", rpm:"gnome-panel-doc~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-extras", rpm:"gnome-panel-extras~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-panel-lang", rpm:"gnome-panel-lang~2.24.1~2.25.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpomme", rpm:"gpomme~1.22~1.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good", rpm:"gstreamer-0_10-plugins-good~0.10.10~3.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-doc", rpm:"gstreamer-0_10-plugins-good-doc~0.10.10~3.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-extra", rpm:"gstreamer-0_10-plugins-good-extra~0.10.10~3.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-0_10-plugins-good-lang", rpm:"gstreamer-0_10-plugins-good-lang~0.10.10~3.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.14.4~8.6.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.14.4~8.6.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.14.4~8.6.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.14.4~8.6.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-lang", rpm:"gtk2-lang~2.14.4~8.6.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvim", rpm:"gvim~7.2~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.12~10.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.12~10.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hci_usb-kmp-default", rpm:"hci_usb-kmp-default~0.1_2.6.27.19_3.2~2.47.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hci_usb-kmp-pae", rpm:"hci_usb-kmp-pae~0.1_2.6.27.19_3.2~2.47.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hci_usb-kmp-trace", rpm:"hci_usb-kmp-trace~0.1_2.6.27.19_3.2~2.47.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hci_usb-kmp-xen", rpm:"hci_usb-kmp-xen~0.1_2.6.27.19_3.2~2.47.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-devel", rpm:"imap-devel~2006c1_suse~127.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-lib", rpm:"imap-lib~2006c1_suse~127.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"intel-iamt-heci-kmp-debug", rpm:"intel-iamt-heci-kmp-debug~3.1.0.31_2.6.27.19_3.2~2.40.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"intel-iamt-heci-kmp-default", rpm:"intel-iamt-heci-kmp-default~3.1.0.31_2.6.27.19_3.2~2.40.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"intel-iamt-heci-kmp-pae", rpm:"intel-iamt-heci-kmp-pae~3.1.0.31_2.6.27.19_3.2~2.40.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"intel-iamt-heci-kmp-trace", rpm:"intel-iamt-heci-kmp-trace~3.1.0.31_2.6.27.19_3.2~2.40.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"intel-iamt-heci-kmp-xen", rpm:"intel-iamt-heci-kmp-xen~3.1.0.31_2.6.27.19_3.2~2.40.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"iscsitarget-kmp-debug", rpm:"iscsitarget-kmp-debug~0.4.15_2.6.27.19_3.2~89.11.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"iscsitarget-kmp-default", rpm:"iscsitarget-kmp-default~0.4.15_2.6.27.19_3.2~89.11.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"iscsitarget-kmp-pae", rpm:"iscsitarget-kmp-pae~0.4.15_2.6.27.19_3.2~89.11.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"iscsitarget-kmp-trace", rpm:"iscsitarget-kmp-trace~0.4.15_2.6.27.19_3.2~89.11.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"iscsitarget-kmp-xen", rpm:"iscsitarget-kmp-xen~0.4.15_2.6.27.19_3.2~89.11.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update17~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update17~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update17~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update17~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update17~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-src", rpm:"java-1_6_0-sun-src~1.6.0.u12~1.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"jhead", rpm:"jhead~2.84~1.24.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-amarok", rpm:"kde4-amarok~2.0.1.1~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-amarok-lang", rpm:"kde4-amarok-lang~2.0.1.1~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm", rpm:"kde4-kdm~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm-branding-upstream", rpm:"kde4-kdm-branding-upstream~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kgreeter-plugins", rpm:"kde4-kgreeter-plugins~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kwin", rpm:"kde4-kwin~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace", rpm:"kdebase4-workspace~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-branding-upstream", rpm:"kdebase4-workspace-branding-upstream~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-devel", rpm:"kdebase4-workspace-devel~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-ksysguardd", rpm:"kdebase4-workspace-ksysguardd~4.1.3~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebluetooth4", rpm:"kdebluetooth4~0.3~4.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-base", rpm:"kernel-debug-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-extra", rpm:"kernel-debug-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-base", rpm:"kernel-default-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-extra", rpm:"kernel-default-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae", rpm:"kernel-pae~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-base", rpm:"kernel-pae-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-extra", rpm:"kernel-pae-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace", rpm:"kernel-trace~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-base", rpm:"kernel-trace-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-extra", rpm:"kernel-trace-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-vanilla", rpm:"kernel-vanilla~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-base", rpm:"kernel-xen-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-extra", rpm:"kernel-xen-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"keyutils", rpm:"keyutils~1.2~107.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kismet", rpm:"kismet~2008_05_R1~19.52.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kqemu-kmp-debug", rpm:"kqemu-kmp-debug~1.4.0pre1_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kqemu-kmp-default", rpm:"kqemu-kmp-default~1.4.0pre1_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kqemu-kmp-pae", rpm:"kqemu-kmp-pae~1.4.0pre1_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kqemu-kmp-trace", rpm:"kqemu-kmp-trace~1.4.0pre1_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kqemu-kmp-xen", rpm:"kqemu-kmp-xen~1.4.0pre1_2.6.27.19_3.2~2.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kvm", rpm:"kvm~78~6.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kvm-kmp-default", rpm:"kvm-kmp-default~78_2.6.27.19_3.2~6.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kvm-kmp-pae", rpm:"kvm-kmp-pae~78_2.6.27.19_3.2~6.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kvm-kmp-trace", rpm:"kvm-kmp-trace~78_2.6.27.19_3.2~6.6.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ldapsmb", rpm:"ldapsmb~1.34b~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit-devel", rpm:"libQtWebKit-devel~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit4", rpm:"libQtWebKit4~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr", rpm:"libattr~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libattr-devel", rpm:"libattr-devel~2.4.43~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-client3", rpm:"libavahi-client3~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-common3", rpm:"libavahi-common3~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-core5", rpm:"libavahi-core5~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-devel", rpm:"libavahi-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib-devel", rpm:"libavahi-glib-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-glib1", rpm:"libavahi-glib1~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject-devel", rpm:"libavahi-gobject-devel~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-gobject0", rpm:"libavahi-gobject0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libavahi-ui0", rpm:"libavahi-ui0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libbluetooth3", rpm:"libbluetooth3~4.22~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.19.0~11.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.19.0~11.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdns_sd", rpm:"libdns_sd~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1-8", rpm:"libgladeui-1-8~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1_0-devel", rpm:"libgladeui-1_0-devel~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgladeui-1_0-doc", rpm:"libgladeui-1_0-doc~3.5.2~7.25.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libhowl0", rpm:"libhowl0~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipulog-devel", rpm:"libipulog-devel~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod", rpm:"libmikmod~3.1.11a~71.56.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod-devel", rpm:"libmikmod-devel~3.1.11a~71.56.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmtp8", rpm:"libmtp8~0.3.4~2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl-devel", rpm:"libopenssl-devel~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopenssl0_9_8", rpm:"libopenssl0_9_8~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-glib10", rpm:"libpackagekit-glib10~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-glib10-devel", rpm:"libpackagekit-glib10-devel~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-qt10", rpm:"libpackagekit-qt10~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpackagekit-qt10-devel", rpm:"libpackagekit-qt10-devel~0.3.11~1.13.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.31~4.37.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.31~4.37.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng12-0", rpm:"libpng12-0~1.2.31~4.37.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpython2_6-1_0", rpm:"libpython2_6-1_0~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1", rpm:"libqdialogsolver1~1.2.6~1.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqdialogsolver1-devel", rpm:"libqdialogsolver1-devel~1.2.6~1.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4", rpm:"libqt4~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel-doc", rpm:"libqt4-devel-doc~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-qt3support", rpm:"libqt4-qt3support~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql", rpm:"libqt4-sql~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-mysql", rpm:"libqt4-sql-mysql~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-postgresql", rpm:"libqt4-sql-postgresql~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-sqlite", rpm:"libqt4-sql-sqlite~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-unixODBC", rpm:"libqt4-sql-unixODBC~4.4.3~11.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-x11", rpm:"libqt4-x11~4.4.3~4.8.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-devel", rpm:"libsatsolver-devel~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc1", rpm:"libtalloc1~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb1", rpm:"libtdb1~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff3", rpm:"libtiff3~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-doc", rpm:"libvirt-doc~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.4.6~11.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-doc", rpm:"libxml2-doc~2.7.1~9.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp", rpm:"libzypp~5.25.3~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp-devel", rpm:"libzypp-devel~5.25.3~0.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lirc-kmp-default", rpm:"lirc-kmp-default~0.8.4_2.6.27.19_3.2~0.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lirc-kmp-pae", rpm:"lirc-kmp-pae~0.8.4_2.6.27.19_3.2~0.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lirc-kmp-trace", rpm:"lirc-kmp-trace~0.8.4_2.6.27.19_3.2~0.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lirc-kmp-xen", rpm:"lirc-kmp-xen~0.8.4_2.6.27.19_3.2~0.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mailman", rpm:"mailman~2.1.11~8.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"module-init-tools", rpm:"module-init-tools~3.4~56.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181", rpm:"mozilla-xulrunner181~1.8.1.19~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181-devel", rpm:"mozilla-xulrunner181-devel~1.8.1.19~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181-l10n", rpm:"mozilla-xulrunner181-l10n~1.8.1.19~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios", rpm:"nagios~3.0.6~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-devel", rpm:"nagios-devel~3.0.6~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nagios-www", rpm:"nagios-www~3.0.6~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nano", rpm:"nano~2.1.7~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-default", rpm:"ndiswrapper-kmp-default~1.53_2.6.27.19_3.2~12.37.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-pae", rpm:"ndiswrapper-kmp-pae~1.53_2.6.27.19_3.2~12.37.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-trace", rpm:"ndiswrapper-kmp-trace~1.53_2.6.27.19_3.2~12.37.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-xen", rpm:"ndiswrapper-kmp-xen~1.53_2.6.27.19_3.2~12.37.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk", rpm:"netatalk~2.0.3~246.13.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"netatalk-devel", rpm:"netatalk-devel~2.0.3~246.13.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-client", rpm:"nfs-client~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-doc", rpm:"nfs-doc~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-kernel-server", rpm:"nfs-kernel-server~1.1.3~18.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.9~2.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p5~15.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-doc", rpm:"ntp-doc~4.2.4p5~15.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ofed-kmp-debug", rpm:"ofed-kmp-debug~1.4_2.6.27.19_3.2~21.15.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ofed-kmp-default", rpm:"ofed-kmp-default~1.4_2.6.27.19_3.2~21.15.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ofed-kmp-pae", rpm:"ofed-kmp-pae~1.4_2.6.27.19_3.2~21.15.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ofed-kmp-trace", rpm:"ofed-kmp-trace~1.4_2.6.27.19_3.2~21.15.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"omnibook-kmp-debug", rpm:"omnibook-kmp-debug~20080627_2.6.27.19_3.2~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"omnibook-kmp-default", rpm:"omnibook-kmp-default~20080627_2.6.27.19_3.2~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"omnibook-kmp-pae", rpm:"omnibook-kmp-pae~20080627_2.6.27.19_3.2~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"omnibook-kmp-trace", rpm:"omnibook-kmp-trace~20080627_2.6.27.19_3.2~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"omnibook-kmp-xen", rpm:"omnibook-kmp-xen~20080627_2.6.27.19_3.2~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp", rpm:"openslp~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-devel", rpm:"openslp-devel~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openslp-server", rpm:"openslp-server~1.2.0~168.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl", rpm:"openssl~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openssl-doc", rpm:"openssl-doc~0.9.8h~28.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opera", rpm:"opera~9.63~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"optipng", rpm:"optipng~0.6.1~10.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"oracleasm-kmp-debug", rpm:"oracleasm-kmp-debug~2.0.5_2.6.27.19_3.2~2.36.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"oracleasm-kmp-default", rpm:"oracleasm-kmp-default~2.0.5_2.6.27.19_3.2~2.36.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"oracleasm-kmp-pae", rpm:"oracleasm-kmp-pae~2.0.5_2.6.27.19_3.2~2.36.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"oracleasm-kmp-trace", rpm:"oracleasm-kmp-trace~2.0.5_2.6.27.19_3.2~2.36.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"oracleasm-kmp-xen", rpm:"oracleasm-kmp-xen~2.0.5_2.6.27.19_3.2~2.36.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.47~12.14.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"parted", rpm:"parted~1.8.8~91.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"parted-devel", rpm:"parted-devel~1.8.8~91.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcfclock-kmp-debug", rpm:"pcfclock-kmp-debug~0.44_2.6.27.19_3.2~227.56.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcfclock-kmp-default", rpm:"pcfclock-kmp-default~0.44_2.6.27.19_3.2~227.56.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcfclock-kmp-pae", rpm:"pcfclock-kmp-pae~0.44_2.6.27.19_3.2~227.56.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcfclock-kmp-trace", rpm:"pcfclock-kmp-trace~0.44_2.6.27.19_3.2~227.56.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Bootloader", rpm:"perl-Bootloader~0.4.81.1~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-DBD-mysql", rpm:"perl-DBD-mysql~4.010~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-base", rpm:"perl-base~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-doc", rpm:"perl-doc~5.10.0~62.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-satsolver", rpm:"perl-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.6~49.14.3", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"plotutils", rpm:"plotutils~2.5~197.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pommed", rpm:"pommed~1.22~1.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powerdevil", rpm:"powerdevil~1.4.1~4.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powerdevil-lang", rpm:"powerdevil-lang~1.4.1~4.5.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi", rpm:"psi~0.12~28.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ptools", rpm:"ptools~0.1~2.16.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pure-ftpd", rpm:"pure-ftpd~1.0.21~182.32.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python", rpm:"python~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-avahi", rpm:"python-avahi~0.6.23~9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-curses", rpm:"python-curses~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-demo", rpm:"python-demo~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-gdbm", rpm:"python-gdbm~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-idle", rpm:"python-idle~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-m2crypto", rpm:"python-m2crypto~0.17~2.1.4", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-rrdtool", rpm:"python-rrdtool~1.3.4~1.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-satsolver", rpm:"python-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-tk", rpm:"python-tk~2.6.0~2.21.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xml", rpm:"python-xml~2.6.0~2.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xpcom190", rpm:"python-xpcom190~1.9.0.6~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt4-x11-tools", rpm:"qt4-x11-tools~4.4.3~4.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"quickcam-kmp-default", rpm:"quickcam-kmp-default~0.6.6_2.6.27.19_3.2~9.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"quickcam-kmp-pae", rpm:"quickcam-kmp-pae~0.6.6_2.6.27.19_3.2~9.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rrdtool", rpm:"rrdtool~1.3.4~1.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rrdtool-devel", rpm:"rrdtool-devel~1.3.4~1.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rsyslog", rpm:"rsyslog~3.18.3~4.33.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-satsolver", rpm:"ruby-satsolver~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-devel", rpm:"samba-devel~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-krb-printing", rpm:"samba-krb-printing~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.2.6~0.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"satsolver-tools", rpm:"satsolver-tools~0.13.2~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sblim-sfcb", rpm:"sblim-sfcb~1.3.2~9.12.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-irc", rpm:"seamonkey-irc~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-spellchecker", rpm:"seamonkey-spellchecker~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-venkman", rpm:"seamonkey-venkman~1.1.14~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squid", rpm:"squid~2.7.STABLE5~1.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p17~10.36.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysvinit", rpm:"sysvinit~2.86~186.16.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tiff", rpm:"tiff~3.8.2~133.35.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tsclient", rpm:"tsclient~2.0.2~2.29.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tsclient-devel", rpm:"tsclient-devel~2.0.2~2.29.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd", rpm:"ulogd~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-mysql", rpm:"ulogd-mysql~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pcap", rpm:"ulogd-pcap~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-pgsql", rpm:"ulogd-pgsql~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ulogd-sqlite", rpm:"ulogd-sqlite~1.24~129.51.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"util-linux", rpm:"util-linux~2.14.1~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim", rpm:"vim~7.2~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-base", rpm:"vim-base~7.2~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-data", rpm:"vim-data~7.2~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2~7.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vinagre", rpm:"vinagre~2.24.1~1.31.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose", rpm:"virtualbox-ose~2.0.6~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-guest-tools", rpm:"virtualbox-ose-guest-tools~2.0.6~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-kmp-debug", rpm:"virtualbox-ose-kmp-debug~2.0.6_2.6.27.19_3.2~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-kmp-default", rpm:"virtualbox-ose-kmp-default~2.0.6_2.6.27.19_3.2~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-kmp-pae", rpm:"virtualbox-ose-kmp-pae~2.0.6_2.6.27.19_3.2~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"virtualbox-ose-kmp-trace", rpm:"virtualbox-ose-kmp-trace~2.0.6_2.6.27.19_3.2~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vmware-kmp-debug", rpm:"vmware-kmp-debug~2008.09.03_2.6.27.19_3.2~5.50.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vmware-kmp-default", rpm:"vmware-kmp-default~2008.09.03_2.6.27.19_3.2~5.50.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vmware-kmp-pae", rpm:"vmware-kmp-pae~2008.09.03_2.6.27.19_3.2~5.50.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vmware-kmp-trace", rpm:"vmware-kmp-trace~2008.09.03_2.6.27.19_3.2~5.50.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wacom-kmp-debug", rpm:"wacom-kmp-debug~0.8.1_2.6.27.19_3.2~6.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wacom-kmp-default", rpm:"wacom-kmp-default~0.8.1_2.6.27.19_3.2~6.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wacom-kmp-pae", rpm:"wacom-kmp-pae~0.8.1_2.6.27.19_3.2~6.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wacom-kmp-trace", rpm:"wacom-kmp-trace~0.8.1_2.6.27.19_3.2~6.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wacom-kmp-xen", rpm:"wacom-kmp-xen~0.8.1_2.6.27.19_3.2~6.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine", rpm:"wine~1.1.9~1.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wine-devel", rpm:"wine-devel~1.1.9~1.11.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.4~2.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-devel", rpm:"wireshark-devel~1.0.4~2.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wmpomme", rpm:"wmpomme~1.22~1.15.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-virtualbox-ose", rpm:"xorg-x11-driver-virtualbox-ose~2.0.6~2.8.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xrdp", rpm:"xrdp~0.4.1~16.7.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~236~1.50.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2", rpm:"yast2~2.17.59~1.2.13", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-bootloader", rpm:"yast2-bootloader~2.17.50~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-devel-doc", rpm:"yast2-devel-doc~2.17.59~1.2.13", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network", rpm:"yast2-network~2.17.66~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-network-devel-doc", rpm:"yast2-network-devel-doc~2.17.66~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-pkg-bindings", rpm:"yast2-pkg-bindings~2.17.31~1.2.10", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-qt-pkg", rpm:"yast2-qt-pkg~2.17.25~1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zypper", rpm:"zypper~1.0.5~2.1.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit", rpm:"PackageKit~0.2.1~15.10", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-devel", rpm:"PackageKit-devel~0.2.1~15.10", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PolicyKit", rpm:"PolicyKit~0.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PolicyKit-devel", rpm:"PolicyKit-devel~0.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.18.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpomme", rpm:"gpomme~1.15~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2", rpm:"gtk2~2.12.9~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-branding-upstream", rpm:"gtk2-branding-upstream~2.12.9~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-devel", rpm:"gtk2-devel~2.12.9~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-doc", rpm:"gtk2-doc~2.12.9~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gtk2-lang", rpm:"gtk2-lang~2.12.9~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvim", rpm:"gvim~7.2~9.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.11~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.11~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.18.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.18.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod", rpm:"libmikmod~3.1.11a~84.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod-devel", rpm:"libmikmod-devel~3.1.11a~84.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"optipng", rpm:"optipng~0.6.2~2.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pommed", rpm:"pommed~1.15~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi", rpm:"psi~0.11.99.1~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim", rpm:"vim~7.2~9.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-base", rpm:"vim-base~7.2~9.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-data", rpm:"vim-data~7.2~9.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2~9.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wmpomme", rpm:"wmpomme~1.15~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-utils", rpm:"apache2-utils~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.4~70.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl", rpm:"curl~7.16.4~16.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-ca-bundle", rpm:"curl-ca-bundle~7.16.4~16.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gpomme", rpm:"gpomme~1.9~4.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvim", rpm:"gvim~7.2~9.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.9_git20070831~13.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.9_git20070831~13.5", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.16.4~16.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl4", rpm:"libcurl4~7.16.4~16.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod", rpm:"libmikmod~3.1.11a~34.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmikmod-devel", rpm:"libmikmod-devel~3.1.11a~34.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"optipng", rpm:"optipng~0.6.2~2.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pommed", rpm:"pommed~1.9~4.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psi", rpm:"psi~0.10~26.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim", rpm:"vim~7.2~9.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-base", rpm:"vim-base~7.2~9.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-data", rpm:"vim-data~7.2~9.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~7.2~9.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wmpomme", rpm:"wmpomme~1.9~4.2", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
