# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-861-1 (libvorbis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66337);
 script_cve_id("CVE-2008-2009", "CVE-2009-3379");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-861-1 (libvorbis)");

 desc = "The remote host is missing an update to libvorbis
announced via advisory USN-861-1.

Details follow:

It was discovered that libvorbis did not correctly handle ogg files with
underpopulated Huffman trees. If a user were tricked into opening a
specially crafted ogg file with an application that uses libvorbis, an
attacker could cause a denial of service. (CVE-2008-2009)

It was discovered that libvorbis did not correctly handle certain malformed
ogg files. If a user were tricked into opening a specially crafted ogg file
with an application that uses libvorbis, an attacker could cause a denial
of service or possibly execute arbitrary code with the user's privileges.
(CVE-2009-3379)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  libvorbis0a                     1.2.0.dfsg-2ubuntu0.3

Ubuntu 8.10:
  libvorbis0a                     1.2.0.dfsg-3.1ubuntu0.8.10.2

Ubuntu 9.04:
  libvorbis0a                     1.2.0.dfsg-3.1ubuntu0.9.04.2

Ubuntu 9.10:
  libvorbis0a                     1.2.0.dfsg-6ubuntu0.1

After a standard system upgrade you need to restart any applications that
use libvorbis, such as Totem and gtkpod, to effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-861-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-861-1 (libvorbis)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.2.0.dfsg-2ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.2.0.dfsg-2ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.2.0.dfsg-2ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.2.0.dfsg-2ubuntu0.3", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.2.0.dfsg-3.1ubuntu0.8.10.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.2.0.dfsg-3.1ubuntu0.8.10.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.2.0.dfsg-3.1ubuntu0.8.10.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.2.0.dfsg-3.1ubuntu0.8.10.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.2.0.dfsg-3.1ubuntu0.9.04.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.2.0.dfsg-3.1ubuntu0.9.04.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.2.0.dfsg-3.1ubuntu0.9.04.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.2.0.dfsg-3.1ubuntu0.9.04.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis-dev", ver:"1.2.0.dfsg-6ubuntu0.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbis0a", ver:"1.2.0.dfsg-6ubuntu0.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisenc2", ver:"1.2.0.dfsg-6ubuntu0.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvorbisfile3", ver:"1.2.0.dfsg-6ubuntu0.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
