///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __SELECTION_MODIFIER_BASE_H
#define __SELECTION_MODIFIER_BASE_H

#include <core/Core.h>

#include <atomviz/AtomViz.h>
#include "../AtomsObjectModifierBase.h"

namespace AtomViz {

/******************************************************************************
* base class for modifies that select atoms based on a specific criterion.
******************************************************************************/
class ATOMVIZ_DLLEXPORT SelectionModifierBase : public AtomsObjectModifierBase
{
protected:

	/// Default constructor.
	SelectionModifierBase(bool isLoading = false) : AtomsObjectModifierBase(isLoading), _selectionShown(true) {
		INIT_PROPERTY_FIELD(SelectionModifierBase, _selectionShown);
	}

public:

	/// Returns whether the selected atoms are made visible.
	bool selectionShown() const { return _selectionShown; }

	/// Sets whether the selected atoms should be made visible.
	/// This actually controls the visibility of the selection data channel.
	void setSelectionShown(bool show) { _selectionShown = show; }

public:

	Q_PROPERTY(bool selectionShown READ selectionShown WRITE setSelectionShown)

protected:

	/// Controls whether the selected atoms should be made visible.
	PropertyField<bool> _selectionShown;

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(SelectionModifierBase)
	DECLARE_PROPERTY_FIELD(_selectionShown)
};

};	// End of namespace AtomViz

#endif // __SELECTION_MODIFIER_BASE_H
