Changes of Note:
- Command line parsing has been reworked to cause invalid options to emit
  an error message.  Stage options specified in pipelines and on the command
  line are handled similarly.
- The dimension PlatformHeading has been renamed to Azimuth.  When looking
  up a dimension by name, the string "platformheading" is still accepted and
  returns Azimuth.
- Errors detected by GDAL are no longer thrown as exceptions.  A log message
  is emitted instead.
- Well-known dimensions are now added to PDAL by editing a JSON file,
  Dimension.json.
- Linking with PDAL using CMake no longer requires explicit linking with
  curl, jsoncpp or arbiter libraries.
- PDAL now searches for plugins in the following locations and order by
  default: ./lib, ../lib, ../bin, the location where PDAL was installed.
- The '--debug' and '--verbose' options are no longer supported as stage
  options.  The '--verbose' option is accepted on the PDAL command line.  The
  '--debug' option is deprecated, and if specified on the command line is
  equivalent to '--verbose=3'.  One can enable logging programmatically by
  calling setLog() on a PipelineManager or a specific stage.
- pdal::Dimension types are now C++11 enumeration classes. The change may
  require editing any Stage implementations you might have and removing the
  extraneous ::Enum type specification.

Enhancements:
- Pipelines can now be read directly from standard input.
- Files can now be read from Amazon S3 buckets by providing an appropriate
  URL.
- Many new filters have been added: filters.approximatecoplanar,
  filters.eigenvalues, filters.estimaterank, filters.hag, filters.normal,
  filters.outlier, filters.pmf, filters.sample.  Most of these are algorithm
  extractions from the PCL library, with the hope of eliminating the need
  for PCL in some future PDAL release.
- The PLY reader now loads dimensions that aren't predefined PDAL dimensions.
- A '--driver' option has been added to allow a specific driver to be loaded
  for a file without regard to its extension.
- The PDAL_DRIVER_PATH environment variable now accepts a list of locations
  to search for drivers.
- Beta release quality drivers improvements in readers.greyhound
- Beta quality implementation of Mongus and Zalik ground filter
- Experimental implementation of Pingel et al. ground filter
- writers.pcd enhancements by Logan Byers (binary, compression) -- requires
  PCL
- Docker images upgraded to Ubuntu Xenial
- Cyclone PTS reader -- readers.pts
- skewness, kurtosis, stddev, and variance added to filters.stats output
- Python API now available https://pypi.python.org/pypi/pdal

Fixes:
- A failure that may have resulted when using filters.hexbin to calculate
  density in the southern hemisphere has been corrected.
- A failure to create the index file with 'pdal tindex' and GDAL 2.X has
  been fixed.
- The '--tindex' option for the 'pdal tindex' command is now a positional
  option as specified in the documentation.
- The icebridge reader now reads the X dimension as longitude and forces
  the value in the range (-180, 180].  It also properly uses the dimension
  Azimuth instead of ScanAngleRank.
- An error in writers.pgpointcloud where it ignored SQL to be run at the end
  of the stage has been fixed.
- An error that might incorrectly write values stored internally as bytes
  when written as a different data type has been fixed.
- A problem where 'pdal info' wouldn't properly report dimension names not
  predefined by PDAL has been fixed.
- A bug in filters.crop that wouldn't properly transform coordinates when
  provided the '--a_srs' option has been fixed.

