/*	test_Authentication

PIRL CVS ID: test_Authentication.java,v 1.5 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.Authentication;

import	java.security.KeyPair;


public class test_Authentication
{
public static boolean
	Verbose = false;

//Test case 1
/*
Check to see if a string password passes
*/
public static boolean test_1 ()
{
try
	{
	if (Verbose)
		System.out.println
			("\ntest_1 -");
	String 
   		password = "password";
	if (Verbose)
		System.out.println
			("  password = " + password + '\n'
			+"  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys();
	if (Verbose)
		System.out.println
			("  encryption_key = Authentication.Public_Key (keys)");
	String
		encryption_key = Authentication.Public_Key (keys);
	if (Verbose)
		System.out.println
			("    " + encryption_key + '\n'
			+"  encrypted_key = "
				+"Authentication.Encoded_Password (password, encryption_key)");
	String
		encrypted_key
			= Authentication.Encoded_Password (password, encryption_key);
	if (Verbose)
		System.out.println
			("    " + encrypted_key + '\n'
			+"  Authentication.Authenticate (keys, encrypted_key, password)");
	boolean
		result = Authentication.Authenticate (keys, encrypted_key, password);
	if (Verbose)
		System.out.println
			("    " + result);
  	return result;	
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return false;
}

//Test case 2
/*
Check to see if a wrong string passes the authenticate check
*/
public static boolean test_2 ()
{
try
	{
	if (Verbose)
		System.out.println
			("\ntest_2 -");
	String 
   		password = "incorrect_password";
	if (Verbose)
		System.out.println
			("  password = " + password + '\n'
			+"  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys();
	if (Verbose)
		System.out.println
			("  encryption_key = Authentication.Public_Key (keys)");
	String
		encryption_key = Authentication.Public_Key(keys);
	if (Verbose)
		System.out.println
			("    " + encryption_key + '\n'
			+"  encrypted_key = "
				+"Authentication.Encoded_Password (password, encryption_key)");
	String
		encrypted_key
			= Authentication.Encoded_Password(password, encryption_key);
	if (Verbose)
		System.out.println
			("    " + encrypted_key + '\n'
			+"  Authentication.Authenticate "
				+"(keys, encrypted_key, \"correct_password\")");
	//	Should fail.
	boolean
  		result = Authentication.Authenticate
					(keys, encrypted_key, "correct_password");
	if (Verbose)
		System.out.println
			("    " + result);
	result = ! result;
  	return result;	
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return false;
}

/*
Test 3 - test with different characters in the password
*/
public static boolean test_3 ()
{
try
	{
	if (Verbose)
		System.out.println
			("\ntest_3 -");
	String 
   		password = "12akdgva3898sdvh_!@#$%^&*(()";
	if (Verbose)
		System.out.println
			("  password = " + password + '\n'
			+"  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys();
	if (Verbose)
		System.out.println
			("  encryption_key = Authentication.Public_Key (keys)");
	String
		encryption_key = Authentication.Public_Key(keys);
	if (Verbose)
		System.out.println
			("    " + encryption_key + '\n'
			+"  encrypted_key = "
				+"Authentication.Encoded_Password (password, encryption_key)");
	String
		encrypted_key
			= Authentication.Encoded_Password (password, encryption_key);
	if (Verbose)
		System.out.println
			("    " + encrypted_key + '\n'
			+"    Authentication.Authenticate (keys, encrypted_key, password)");
	boolean
		result = Authentication.Authenticate (keys, encrypted_key, password);
	if (Verbose)
		System.out.println
			("    " + result);
  	return result;	
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return false;
}

/*
test_4 - try to serialize a null encryption key
*/
public static boolean test_4 ()
{
if (Verbose)
	System.out.println
		("\ntest_4 -");
boolean
	result = false;
try
	{
	if (Verbose)
		System.out.println
			("  Authentication.Public_Key (null)");
	String
		encryption_key = Authentication.Public_Key (null);
	if (Verbose)
		System.out.println
			("    " + encryption_key);
	result = (encryption_key == null);
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return result;
}

/*
test 5 - try to encrypt a null password
*/
public static boolean test_5 ()
{
if (Verbose)
	System.out.println
		("\ntest_5 -");
boolean
	result = false;
try
	{
	if (Verbose)
		System.out.println
			("  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys();
	if (Verbose)
		System.out.println
			("  encryption_key = Authentication.Public_Key (keys)");
	String
		encryption_key = Authentication.Public_Key (keys);
	if (Verbose)
		System.out.println
			("    " + encryption_key + '\n'
			+"  encrypted_key = "
				+"  Authentication.Encoded_Password (null, encryption_key)");
	String
		encrypted_key
			= Authentication.Encoded_Password (null, encryption_key);
	if (Verbose)
		System.out.println
			("    " + encrypted_key);
	result = (encrypted_key == null);
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return result;
}

/*
test 6 - try to encrypt using a nonsensical key
*/
public static boolean test_6 ()
{
if (Verbose)
	System.out.println
		("\ntest_6 -");
boolean
	result = false;
try
	{
	if (Verbose)
		System.out.println
			("  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys ();
	if (Verbose)
		System.out.println
			("  encryption_key = Authentication.Public_Key (keys)");
	String
		encryption_key = Authentication.Public_Key (keys);
	if (Verbose)
		System.out.println
			("    " + encryption_key + '\n'
			+"  Authentication.Encoded_Password (\"password\", \"nonsense\")");
	String
		encrypted_key
			= Authentication.Encoded_Password ("password", "nonsense");
	if (Verbose)
		System.out.println
			("    " + encrypted_key);
	result = (encrypted_key == null);
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return result;
}

/*
test 7 - try to decrypt using a nonsensical key
*/
public static boolean test_7 ()
{
if (Verbose)
	System.out.println
		("\ntest_7 -");
boolean
	result = false;
try
	{
	if (Verbose)
		System.out.println
			("  keys = Authentication.Keys()");
	KeyPair
		keys = Authentication.Keys ();
	if (Verbose)
		System.out.println
			("    Authentication.Authenticate (keys, "
				+"\"nonsense\", \"password\")");
	//	Should fail.
	result = Authentication.Authenticate (keys, "nonsense", "password");	
	if (Verbose)
		System.out.println
			("    " + result);
	result = ! result;
	}
catch (Exception exception)
	{
	System.out.println
		("!!! Exception: " + exception);
	}
return result;
}


private static int 
	correct_checks = 0,
	total_checks = 0;


public static void check
	(
	boolean	passed,
	String	report
	)
{
total_checks++;
if (passed)
	{
	correct_checks++;
	System.out.println ("PASS: " + report);
	}
else
	System.out.println ("FAIL: " + report);
}


public static void main(String [] args)
{
if (args.length > 0 &&
	args[0].startsWith ("-v"))
	Verbose = true;

check (test_1 (), "Simple password string does Authenticate.");
check (test_2 (), "Incorrect encoded password string does not Authenticate.");
check (test_3 (), "Special characters in the password string do Autenticate.");
check (test_4 (), "Public_Key (null) returns null.");
check (test_5 (), "Encoded_Password (null, public_key) returns null.");
check (test_6 (), "Encoded_Password (\"password\", \"nonsense\") returns null.");
check (test_7 (), "Authenticate (keys, \"nonsense\", \"password\") fails.");

System.out.println ("\n"
	+ "Checks: " + total_checks + '\n'
	+ "Passed: " + correct_checks);
}

}
