/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef PGAME_HEADER
#define PGAME_HEADER

#include <Plasma/PopupApplet>
#include <Plasma/ScrollWidget>
#include <KServiceGroup>

#include "ui_gamedialog.h"

class QAction;
class ListWidget;
class ListWidgetItem;
class PGame : public Plasma::PopupApplet
{
    Q_OBJECT


    public:
        PGame(QObject *parent, const QVariantList &args);
        ~PGame();

        void init();


    protected:
        QList<QAction*> contextualActions();
        QGraphicsWidget *graphicsWidget();
        
  
    private:
        QGraphicsWidget *m_widget;
        ListWidget *m_listWidget;
        Ui::GameDialog ui_gameDialog;
        ListWidgetItem *m_currentItem;
        
        
    private slots:
        void showGameDialog();
        void createGame();
        void editGame();
        void removeGame();
        void saveConfig();
        void loadConfig();
        void gameChanged();
        void runGame();
        void deleteProcess(const int &);
        void firstStart();
        void browse(KServiceGroup::Ptr group);
        void itemDroped(ListWidgetItem *item);
   
   
};
 

K_EXPORT_PLASMA_APPLET(pgame, PGame)


#endif
