/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngInputStream;
import com.sixlegs.png.StateMachine;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class ImageDataInputStream
extends InputStream {
    private final PngInputStream in;
    private final StateMachine machine;
    private final byte[] onebyte = new byte[1];
    private boolean done;

    public ImageDataInputStream(PngInputStream in, StateMachine machine) {
        this.in = in;
        this.machine = machine;
    }

    public int read() throws IOException {
        return this.read(this.onebyte, 0, 1) == -1 ? -1 : 0xFF & this.onebyte[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.done) {
            return -1;
        }
        try {
            int total = 0;
            while (total != len && !this.done) {
                while (total != len && this.in.getRemaining() > 0) {
                    int amt = Math.min(len - total, this.in.getRemaining());
                    this.in.readFully(b, off + total, amt);
                    total += amt;
                }
                if (this.in.getRemaining() > 0) continue;
                this.in.endChunk(this.machine.getType());
                this.machine.nextState(this.in.startChunk());
                this.done = this.machine.getType() != 1229209940;
            }
            return total;
        }
        catch (EOFException e) {
            this.done = true;
            return -1;
        }
    }
}

