/* $Cambridge: hermes/src/prayer/cmd/cmd_roles_list.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_roles_list(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct options *options = session->options;
    struct buffer *b = request->write_buffer;
    struct list_item *li;
    struct assoc *h = NIL;
    unsigned long offset = 0;

    if (request->method == POST) {
        request_decode_form(request);
        h = request->form;

        if (assoc_lookup(h, "sub_cancel")) {
            session_redirect(session, request, "manage");
            return;
        }

        if (assoc_lookup(h, "sub_new")) {
            session_redirect(session, request, "roles_entry");
            return;
        }
    }

    for (li = options->role_list->head; li; li = li->next) {
        struct role *role = (struct role *) li;

        template_vals_foreach_init(tvals, "@roles", offset);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "alias", role->name);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "personal", role->personal);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "from", role->from);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "reply_to", role->reply_to);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "fcc", role->fcc);
        template_vals_foreach_string(tvals, "@roles", offset,
                                     "signature", role->signature);
        offset++;
    }

    session_seed_template(session, tvals);
    template_expand("roles_list", tvals, b);
    response_html(request, 200);
}
