# Copyright © 2015 Piotr Ożarowski <piotr@debian.org>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import logging
from functools import wraps
from pypi2deb.cache import load as _cache_load, dump as _cache_dump

log = logging.getLogger('pypi2deb')


def cache(ttl=3600, key=None, prefix=None):
    """Cache decorated funtion's result.

    :param key: static cache key
    :param prefix: prepened it to the autogenerated key
    """

    def _cache(func):
        func_name = func.__name__

        @wraps(func)
        def __cache(*args, **kwargs):
            if key:
                cache_key = key
            else:
                cache_key = "%s:%s:%s" % (func_name, args, kwargs)
            if prefix:
                cache_key = "%s:%s" % (prefix, cache_key)

            res = _cache_load(cache_key)
            if res is None:
                res = func(*args, **kwargs)
                if res is not None:
                    _cache_dump(cache_key, res, ttl)

            return res
        return __cache
    return _cache
