# Version 0.71

Released April 21, 2025

- Add French Southern Territories holidays (#2442 by @LuccaAug, @arkid15r)
- Add Oman holidays (#2463 by @Wasif-Shahzad)
- Add Sierra Leone holidays (#2433 by @SammanSarkar, @arkid15r)
- Add Suriname holidays (#2465 by @kritibirda26)
- Update .po files generator (#2459 by @KJhellico, @arkid15r)
- Update .po files generator (#2470 by @KJhellico)
- Update BY.po files (#2452 by @arkid15r)
- Update Pakistan holidays: add Youm-e-Takbeer holiday (#2446 by @w3stling)
- Update Python latest supported version format (#2466 by @arkid15r)
- Update RELEASE.md (#2484 by @arkid15r)
- Update South Korea holidays: add 2025 Presidential Election Day (#2451 by @YiGeon)
- Update l10n related documentation: detailed explain of language parameter behavior (#2396 by @shreyanshVIT23, @arkid15r)
- Update mypy configuration (#2464 by @arkid15r)
- Add FUNDING.yml (#2450 by @arkid15r)

# Version 0.70

Released April 7, 2025

- Add iCalendar export support (#2362 by @PPsyrius, @kawazap)
- Add Antigua and Barbuda holidays (#2395 by @kritibirda26)
- Add Fiji holidays (#2354 by @Prateekshit73, @arkid15r, @kasya, @PPsyrius)
- Add Guinea holidays (#2398 by @nalin-28, @arkid15r)
- Add Ivory Coast holidays (#2388 by @kritibirda26, @arkid15r)
- Add Qatar holidays (#2409 by @Wasif-Shahzad, @arkid15r)
- Update Argentina holidays: add categories and subdivisions support (#2375 by @KJhellico)
- Update India holidays: Hindi l10n fixes (#2393 by @Ninad0109)
- Update Pakistan holidays: add 2023-2024 exact dates (#2380 by @Wasif-Shahzad)
- Update Pakistan holidays: add l10n support (en_PK, en_US, ur_PK) (#2385 by @Wasif-Shahzad, @KJhellico)
- Update Philippines holidays: 2025 Eid'l Fitr (#2367 by @kleo)
- Update Philippines holidays: adjust Bonifacio Day for 2023 (#2370 by @w3stling)
- Update README.md badges (#2379 by @arkid15r)
- Update Timor-Leste holidays: add `en_TL`, `th` l10n, update `en_US` l10n (#2407 by @PPsyrius)
- Update `HolidayBase::pop_named`: add support for more lookup types (#2140 by @wth-d, @KJhellico)
- Update `_ThaiLunisolar` and `ThaiCalendarHolidays` documentation (#2439 by @PPsyrius)
- Update pyproject.toml: align with PEP 639 metadata format (#2363 by @KJhellico)
- Update release notes generator (#2374 by @KJhellico)
- Update tests requirements (#2383 by @KJhellico)
- Added commit SHAs instead of versions (#2384 by @samyak003, @arkid15r)
- Adjust project files after migration to MkDocs (#2381 by @KJhellico)
- Migrate Documentation from Sphinx to MkDocs (#2289 by @Roshan-1024, @arkid15r, @KJhellico, @PPsyrius)
- Reformat .po files (#2356 by @KJhellico)
- Reformat BY.po files (#2365 by @PPsyrius)

# Version 0.69

Released March 17, 2025

- Introduce HolidayBase methods for proper serialization (#2333 by @KJhellico)
- Add Macau holidays (#2323 by @PPsyrius)
- Update IN holidays and localization (#2259 by @ankushhKapoor, @KJhellico)
- Update Poland holidays: add `de` localization (#2346 by @pyniuX)
- Fix l10n handling (#2340 by @KJhellico)
- Update Hong Kong holidays: standardizes `en_US` l10n with China's and Macau's implementation (#2326 by @PPsyrius)
- Update Indonesia holidays: 2031-2050 Day of Silence (Nyepi) data, migrate to `BalineseSakaCalendarHolidays` (#2328 by @PPsyrius)
- Update Philippines holidays: 2025 Eid'l Fitr and Eid'l Adha Tentative Date (#2332 by @PPsyrius)
- Update Taiwan holidays: add categories support (#2349 by @PPsyrius, @arkid15r)
- Update Timor Leste holidays: fix 2025 Islamic holidays (#2327 by @PPsyrius)
- Update US holidays: add federal holidays as GOVERNMENT category (#2297 by @KJhellico)
- Update US holidays: аdd additional MI state holidays (#2325 by @mcvic1rj, @KJhellico)
- Update `IslamicHolidays`: add an option whether to add estimation label to holiday name (#2298 by @KJhellico)

# Version 0.68

Released March 3, 2025

- Fix 2025 Chinese Calendar's Birthday of Buddha (#2310 by @PPsyrius)
- Update AZ holidays: add 2025 substituted holidays (#2302 by @KJhellico)
- Update Kenya holidays, add l10n support (#2316 by @KJhellico)
- Update Malaysia holidays (#2309 by @KJhellico)
- Update Zenodo record URL in README (#2317 by @KJhellico)
- Update issue templates (#2307 by @arkid15r)
- Update l10n scripts (#2318 by @KJhellico, @arkid15r)
- Add .coderabbit.yaml (#2322 by @arkid15r)

# Version 0.67

Released February 17, 2025

- Add Saint Lucia holidays (#2266 by @Prateekshit73)
- Add Tuvalu holidays (#2295 by @Prateekshit73, @arkid15r)
- Update Greenland holidays l10n (#2288 by @KJhellico)
- Update Hong Kong holidays: add l10n support (#2268 by @PPsyrius)
- Update Hong Kong holidays: fix `th` l10n typo (#2293 by @PPsyrius)
- Update Panama holidays, add l10n support (#2275 by @KJhellico)
- Update README: add DOI (#2286 by @arkid15r)
- Update United Kingdom & Isle of Man holidays: add l10n support (#2258 by @PPsyrius, @arkid15r, @KJhellico)
- Update internal scripts (#2284 by @KJhellico)
- Update subdivision names for Presidents' Day in the United States (#2299 by @parkerbxyz, @arkid15r, @KJhellico)
- Add Python syntax check with ruff-pyupgrade rules (#2294 by @KJhellico)
- Add make script for Windows (#2277 by @KJhellico)
- Check .mo rather than .po files in TestListLocalizedEntities (#2273 by @cjwatson, @arkid15r)
- Implement HolidayBase::get_closest_holiday functionality (#2211 by @Rosi2143, @arkid15r)
- Unify certain holidays names translation (#2285 by @KJhellico)

# Version 0.66

Released February 3, 2025

- Add Sri Lanka holidays (#2228 by @Prateekshit73, @arkid15r, @KJhellico, @PPsyrius)
- Fix typo in CONTRIBUTING.rst (#2264 by @KJhellico)
- Update Czechia holidays (#2248 by @KJhellico)
- Update Germany holidays: add Corpus Christi in CATHOLIC category (#2253 by @KJhellico)
- Update Iceland holidays: add HALF_DAY holidays (#2249 by @KJhellico)
- Update Iran holidays (#2234 by @KJhellico)
- Update PR exclusion logic (#2233 by @arkid15r)
- Update Slovakia holidays: Constitution Day is working day since 2024 (#2235 by @KJhellico, @arkid15r)
- Update Slovenia holidays (#2237 by @KJhellico)
- Update Sweden holidays: fix All Saints' Day (#2252 by @KJhellico)
- Update Thailand holidays: refactor Royal Ploughing Ceremony code (#2247 by @PPsyrius)
- Update United Arab Emirates holidays: add `th` l10n, exact 2017-2025 entries (#2263 by @PPsyrius)
- Update Vatican City holidays: add missing holidays, l10n support (#2250 by @PPsyrius)
- Update automatic snapshots update workflow (#2254 by @KJhellico)
- Update some holidays Ukrainian translations (#2265 by @KJhellico)
- Add Israel holidays localization: th (#2262 by @PPsyrius)
- Add West Frisian language (#2246 by @waarissyb, @arkid15r)
- Pin CI/CD Ubuntu version (#2245 by @arkid15r)
- Remove .po files from distribution bundles (#2243 by @KJhellico)

# Version 0.65

Released January 20, 2025

- Update Afghanistan and Iran holidays: change weekend to FRI-SAT and FRI respectively (#2223 by @gio8tisu, @arkid15r)
- Update Afghanistan holidays (#2221 by @KJhellico)
- Update South Korea holidays: 2025 temporary public holidays (#2218 by @YiGeon)
- Update ruff from v0.8.6 to v0.9.1 (#2224 by @arkid15r)
- Add faster date parsing from strings in ISO 8601 format (#2227 by @KJhellico)
- Add signed artifacts path (#2216 by @arkid15r)

# Version 0.64

Released January 6, 2025

- Introduce `common.WorkingDayTests` class (#2207 by @KJhellico)
- Refactor XNYS holidays: standardize US market holidays days of mourning entries (#2213 by @PPsyrius)
- Add Afghanistan holidays (#2198 by @Prateekshit73, @arkid15r, @PPsyrius)
- Add `HebrewCalendarHolidays` to holidays groups, refactor Israel holidays (#2186 by @KJhellico)
- Update "Set up Python" to use 3.13 (#2180 by @arkid15r)
- Update Belarus holidays: add ru & th l10n, 2024-2025 substituted holidays (#2192 by @PPsyrius)
- Update El Salvador holidays, add l10n support (#2209 by @KJhellico)
- Update Montenegro holidays, add l10n support (#2191 by @KJhellico)
- Update Poland holidays: add Christmas Eve holiday since 2025 (#2210 by @KJhellico)
- Update Ukraine holidays in 1991 (#2199 by @KJhellico)
- Update XNYS: add a Day of Mourning for President Jimmy Carter (#2201 by @tackerfrink)
- Update working days calculation (#2197 by @KJhellico, @arkid15r)
- Add Norway holidays localization: th (#2200 by @ansntu)
- Add Russia holidays localization: th (#2190 by @PPsyrius, @arkid15r)
- Add Ukraine holidays localization: th (#2189 by @PPsyrius, @arkid15r)
- Sign release artifacts using Sigstore (#2195 by @arkid15r)

# Version 0.63

Released December 16, 2024

- Update CI/CD trigger section (#2170 by @arkid15r)
- Update KZ holidays: add 2025 special holidays (#2167 by @qaziqarta)
- Update Thailand holidays: extend support year down to 1914 (#2166 by @PPsyrius)
- Add French subdivision aliases (#2162 by @bors-ltd)
- Align financial markets MIC codes with ISO 10383 (#2158 by @KJhellico)
- Enforce 100% test coverage (#2173 by @arkid15r)
- Inline single-use variables, update .py files formatting (#2161 by @KJhellico)

# Version 0.62

Released December 2, 2024

- Introduce start/end year for entity (#2141 by @KJhellico)
- Add Guernsey holidays (#2135 by @PPsyrius)
- Update AZ holidays: add 2025 special holidays (#2154 by @KJhellico)
- Update Argentina holidays: Add 2025 Bridge Public Holidays (#2146 by @PPsyrius)
- Update CA holidays: Nunavut Day is NU public holiday since 2020 (#2143 by @KJhellico)
- Update Finland holidays: fix Independence Day appearing pre-1917 (#2145 by @PPsyrius)
- Update Paraguay holidays (#2151 by @KJhellico)
- Update Timor Leste holidays: Add 2024 Nov 29 Special Holiday (#2150 by @PPsyrius)
- Update pyproject.toml: clarify project summary (#2139 by @arkid15r)
- Add SECURITY.md (#2142 by @arkid15r)

# Version 0.61

Released November 18, 2024

- Add financial markets l10n support (#2116 by @KJhellico)
- Refactor some `if len(container)...` cases to `if container...` (#2118 by @arkid15r)
- Add "Brasil, Bolsa, Balcão" ([B]³) holidays (#2109 by @araggohnxd, @arkid15r, @KJhellico, @PPsyrius)
- Update Brazil holidays, add l10n support (#2113 by @KJhellico)
- Update Brunei holidays: 1998-2003, 2006-2025 exact dates (#2107 by @PPsyrius)
- Update CH holidays: rename Neujahrestag to Neujahrstag (#2121 by @kurtkeller, @arkid15r)
- Update Cambodia holidays: add Peace Day in Cambodia (#2108 by @PPsyrius)
- Update China holidays in 2025 (#2124 by @KJhellico)
- Update Thailand holidays: 2025-2026 Bridge Public Holidays (#2123 by @PPsyrius)
- Update Unites States holidays: remove Columbus Day from countrywide holidays (#2106 by @KJhellico)
- Update `TestCase::assertLocalizedHolidays`: add subdivisions holidays support (#2117 by @KJhellico)
- Update helpers::_normalize_arguments, add helpers tests (#2122 by @arkid15r)
- Update ruff configuration: add Pylint errors check (#2119 by @KJhellico)
- Add Europe Day to InternationalHolidays (#2114 by @KJhellico)
- Add Portugal subdivision aliases (#2110 by @dgomes)

# Version 0.60

Released November 4, 2024

- Refactor Australia tests (#2088 by @KJhellico)
- Refactor Cambodia and Laos test cases (#2086 by @PPsyrius)
- Refactor Canada tests (#2084 by @KJhellico)
- Refactor United States tests (#2087 by @KJhellico)
- Refactor v1 incompatibility warning (#2100 by @arkid15r)
- Update the Philippines holidays: add `en_PH`, `en_US`, `fil`, `th` localization (#2093 by @PPsyrius, @arkid15r)
- Fix `make l10n` removing loc comment for Asarnha Bucha (#2091 by @PPsyrius)
- Fixed Thai Calendar test case coverage (#2090 by @PPsyrius)
- Improve .po files "Language-Team" header consistency (#2098 by @arkid15r)
- Update Albania holidays, add l10n support (#2104 by @KJhellico)
- Update Australia holidays: remove `Adelaide Cup Day` holiday pre-1973 for South Australia (#2082 by @PPsyrius)
- Update CONTRIBUTING.rst (#2085 by @arkid15r)
- Update Germany holidays: add East German Uprising Day 2028 in Berlin (#2092 by @PPsyrius)
- Update Indonesia holidays: `th` localization, more refractor (#2097 by @PPsyrius)
- Update Indonesia holidays: add 2024 Local Election, exact historic dates from 1963 onwards (#2102 by @PPsyrius)
- Update Spain holidays in 2025 (#2080 by @KJhellico)
- Update Thailand holidays in 2025 (#2081 by @PPsyrius)
- Update Timor-Leste holidays (#2078 by @KJhellico)
- Update United States holidays: Alaska state holidays correction (#2083 by @PPsyrius)
- Simplify PR template (#2099 by @arkid15r)

# Version 0.59

Released October 21, 2024

- Update Vietnam holidays: add `th` localization (#2060 by @PPsyrius)
- Update Germany holidays: add Liberation from Nazi Regime Day 2025 in Berlin (#2052 by @hf-kklein, @PPsyrius)
- Update Johor (Malaysia) and United Arab Emirates `weekend` observance, cleanup others (#2048 by @PPsyrius)
- Update Vietnam holidays (#2049 by @KJhellico)
- Update `InternationalHolidays::_add_world_war_two_victory_day()` method (#2064 by @KJhellico)
- Update `holidays` package metadata (#2063 by @arkid15r)
- Update metadata Python versions (#2069 by @arkid15r)
- Add `EasternCalendarHolidays` to holidays groups (#2062 by @KJhellico)
- Drop Python 3.8 support (#2042 by @PPsyrius)
- Satisfy mypy requirements (#2053 by @arkid15r)

# Version 0.58

Released October 7, 2024

- Add Congo holidays (#2037 by @PPsyrius)
- Add Saint Kitts & Nevis holidays (#2005 by @PPsyrius, @arkid15r)
- Add Vietnamese translation of VietNam holidays (#2025 by @vunhatchuong, @arkid15r)
- Update Kazakhstan holidays: add substituted holidays, localization (#2023 by @KJhellico)
- Update Malaysia holidays: add `th` localization (#2030 by @PPsyrius)
- Update Singapore holidays: add `en_SG`, `en_US`, `th` localization (#2031 by @PPsyrius)
- Update Sweden holidays: add `th` localization (#2029 by @PPsyrius)
- Update Azerbaijan holidays in 2024 (#2018 by @KJhellico)
- Update Curaçao holidays: add HALF_DAY holidays (#2039 by @KJhellico)
- Update Japan holidays (#2013 by @KJhellico)
- Update Nicaragua holidays (#2011 by @KJhellico)
- Update Taiwan holidays (#2026 by @KJhellico, @arkid15r)
- Update US holidays: American Samoa holidays (#2017 by @KJhellico)
- Update United States holidays: fix Washington's Birthday in GA & IN (#2014 by @KJhellico)
- Update `ci` label configuration (#2009 by @arkid15r)
- Update apostrophes: change `’` to `'` (#2016 by @arkid15r)
- Update working day related calculations (#2010 by @KJhellico, @arkid15r)
- Add @PPsyrius to CODEOWNERS (#2008 by @arkid15r)
- Move to `holidays` from `python-holidays` (#2027 by @arkid15r)
- Remove deprecated `fix-encoding-pragma`, add `pyupgrade` (#2007 by @PPsyrius, @arkid15r)

# Version 0.57

Released September 16, 2024

- Update Australia holidays: add `en_AU`, `en_US`, `th` localization (#1977 by @PPsyrius)
- Fix some docstrings (#1994 by @KJhellico)
- Update Australia holidays: fix Christmas Day in ACT (#1986 by @KJhellico)
- Update Germany holidays: add `th` localization, deprecated non-standard ISO code, add subdivision aliases (#1979 by @PPsyrius, @arkid15r)
- Update Jersey holidays (#1971 by @PPsyrius)
- Update South Korea holidays: add Armed Forces Day in 2024 (#1973 by @KJhellico)
- Update examples to reflect recent holidays changes (#1978 by @KJhellico)
- Add Frances Xavier Cabrini Day for United States, Colorado (#1995 by @e2thenegpii, @arkid15r)
- Extend `_ThaiLunisolar` calendar support to 2157 (#1981 by @PPsyrius)
- Unify en_US Islamic holidays name translation (#1984 by @KJhellico)

# Version 0.56

Released September 2, 2024

- Refactor Lao New Year holidays (#1962 by @PPsyrius)
- Add 1991-2022 Russian substituted holidays (#1957 by @PPsyrius)
- Add Dominica holidays (#1956 by @PPsyrius)
- Add Haiti holidays (#1932 by @PPsyrius, @arkid15r)
- Change "St." to "Saint" in holidays names (#1966 by @KJhellico)
- Update Brunei Darussalam islamic holidays for 2024 (#1937 by @PPsyrius)
- Update Cambodian holidays for 2024 (#1936 by @PPsyrius)
- Update Dominican Republic holidays: fix Restoration Day (#1965 by @KJhellico, @arkid15r)
- Update HU: add 2025 substituted holidays (#1954 by @Gizsviu)
- Update Philippines holidays (#1938 by @KJhellico)
- Update SBOM artifact path (#1934 by @arkid15r)
- Update Snapshot for 0.55 changes (#1935 by @PPsyrius)
- Update `numpy` test requirements (#1944 by @PPsyrius, @arkid15r)
- Update pyproject.toml: remove `target-version` from tool.ruff (#1950 by @arkid15r)
- Add Easter Tuesday to Christian holidays group (#1959 by @KJhellico)
- Add New Zealand Subdivision Aliases (`EN`, `MI`, HASC) (#1952 by @PPsyrius)
- Add PR labeler (#1968 by @arkid15r)
- Add Python 3.13 (beta) to CI/CD (#1949 by @KJhellico)
- Add automatic snapshots update workflow (#1939 by @arkid15r)
- Migrate deprecated Bosnia-Herzegovina subdivisions to subdivision aliases (#1947 by @PPsyrius)
- Migrate deprecated Italy subdivisions to subdivision aliases (#1951 by @PPsyrius)
- Migrate deprecated United Kingdom subdivisions to subdivision aliases (#1945 by @PPsyrius, @KJhellico)
- Restore Malaysia's 3-letter code as subdivisions aliases (#1946 by @PPsyrius)
- Standardize snapshot names (#1967 by @arkid15r)

# Version 0.55

Released August 19, 2024

- Add Samoa holidays (#1914 by @kasya)
- Fix misleading France subdivision (#1931 by @MichaelMure)
- Update CI/CD: add CodeQL workflow (#1910 by @arkid15r)
- Update CI/CD: simplify gh release upload (#1924 by @arkid15r)
- Update Github release upload process (#1902 by @arkid15r)
- Update SG: add 2025 official holidays (#1903 by @mborsetti, @arkid15r)
- Update UA: move martial law holidays to WORKDAY category (#1921 by @KJhellico)
- Update pre-commit: add bandit (#1913 by @arkid15r)
- Update utils.py (#1908 by @JohnRoz, @arkid15r)
- Add special weekends format for certain countries (#1923 by @PPsyrius, @arkid15r)
- Implement simple CycloneDX SBOM generation (#1925 by @arkid15r)

# Version 0.54

Released August 5, 2024

- Add Mauritania holidays (#1884 by @kasya)
- Fix Malawi tests (#1880 by @arkid15r)
- Update CI/CD pip caching (#1866 by @arkid15r)
- Update FI: add unofficial holidays (#1885 by @alexei-mobal, @arkid15r)
- Update Finland holidays l10n (#1883 by @KJhellico)
- Update PR template (#1894 by @arkid15r)
- Update RU: add 2025 substituted holidays (#1886 by @Alexeyzhu)
- Update docs requirements: revert sphinx to v7.4.7 (#1893 by @arkid15r)
- Update pre-commit automatic update (#1896 by @arkid15r)
- Update release process: upload artifacts to Github (#1898 by @arkid15r)
- Add documentation build test to CI/CD (#1895 by @KJhellico)
- Don't run tests on Github readonly queue push events (#1868 by @arkid15r)
- Drop PyPy support (#1878 by @arkid15r)

# Version 0.53

Released July 15, 2024

- Update Chile holidays: add bank holidays (#1857 by @KJhellico)
- Extend `HolidayBase::__setitem__` to handle names including '; ' (#1858 by @arkid15r)

# Version 0.52

Released July 1, 2024

- Update CI/CD: don't cancel concurrent jobs for dev/main/v1 (#1840 by @arkid15r)
- Update Italy holidays: add Venice provincial holiday (#1842 by @KJhellico)
- Update coverage badge (#1839 by @arkid15r)
- Update docs: add years example (#1851 by @arkid15r)
- Update v1 incompatibility warning (#1850 by @arkid15r)
- Add GitHub issue templates (#1845 by @arkid15r)
- Tune up CI/CD jobs concurrency (#1834 by @arkid15r)

# Version 0.51

Released June 17, 2024

- Update Aruba and Curaçao holidays l10n (split locales) (#1827 by @KJhellico)
- Update Brazil holidays: add new Nov 20 holiday (#1832 by @KJhellico)
- Update CI/CD job concurrency (#1823 by @arkid15r)
- Update CI/CD job concurrency (#1830 by @arkid15r)
- Update README.rst (#1828 by @arkid15r)
- Update ruff configuration (#1819 by @arkid15r)
- Align India subdivisions with ISO 3166-2 (#1821 by @KJhellico)
- Migrate to codecov.io (#1818 by @arkid15r)
- Narrow down ignored warnings (#1816 by @arkid15r)

# Version 0.50

Released June 3, 2024

- Refactor some holidays with uncommon rules (#1807 by @KJhellico)
- Add Greenland holidays (#1811 by @Klintrup, @arkid15r)
- Fix docs: update Italy docstring (#1808 by @arkid15r)
- Update Italy holidays (#1805 by @KJhellico)
- Add 2024 Russian Substituted Holidays (#1799 by @PPsyrius)
- Add Georgian government holiday for May 17, 2024 (#1802 by @PPsyrius, @arkid15r)
- Add v1 future incompatibility warning (#1801 by @arkid15r)
- Migrate Japan holidays to ObservedHolidayBase (#1810 by @KJhellico)
- Synchronize entity dynamic imports (#1794 by @Izzette)

# Version 0.49

Released May 20, 2024

- Refactor Laos holidays (#1797 by @KJhellico)
- Add IFEU holidays (#1792 by @benjfield, @arkid15r)
- Update Hong Kong holidays (#1767 by @KJhellico, @arkid15r)
- Update Malaysia holidays (#1791 by @KJhellico)
- Update observed rules: add holiday removal support (#1796 by @arkid15r)
- Address numpy int argument conversion issue (#1782 by @arkid15r)
- Replace `datetime::timedelta` with custom function (#1785 by @KJhellico)

# Version 0.48

Released May 6, 2024

- Introduce workdays calculation support (#1773 by @KJhellico)
- Refactor `HolidayBase::__getattr__`: speed up \_add_holiday_* methods (#1764 by @KJhellico)
- Add Palau holidays (#1776 by @PPsyrius, @arkid15r)
- Update Greece holidays: move 2024 Labor Day to May 7 (#1786 by @KJhellico)
- Update Timor-Leste holidays (#1772 by @KJhellico)
- Update United States holidays: fix Confederate Memorial Day in MS (#1775 by @KJhellico)
- Update badges in README (#1770 by @KJhellico)
- Update CI/CD: fix macOS Python versions (#1778 by @arkid15r)
- Extend HolidayBase::_add_holiday family methods with Easter support (#1762 by @KJhellico)
- Prioritize entity default holiday category processing (#1769 by @KJhellico)

# Version 0.47

Released April 15, 2024

- Refactor some sequential holidays (#1750 by @KJhellico)
- Add Jordan holidays (#1746 by @firaskafri, @arkid15r)
- Change contributors badge placement (#1753 by @arkid15r)
- Update Australia holidays: fix Sovereign's Birthday dates in WA (#1757 by @KJhellico)
- Update Eid al-Fitr 2024 dates (#1758 by @KJhellico)
- Update European Central Bank holidays (#1754 by @KJhellico)
- Update Poland holidays: fix Ascension Day (#1751 by @KJhellico)
- Update South Africa holidays: add public holiday on May 29, 2024 (#1749 by @KJhellico)
- Update contributing guidelines (#1752 by @arkid15r)

# Version 0.46

Released April 1, 2024

- Fix Romanian language strings: replace U+015F with proper U+0219 (#1739 by @KJhellico)
- Update (c) in file headers and LICENSE (#1672 by @dr-prodigy)
- Update Australia holidays (#1736 by @KJhellico)
- Update Makefile clean action (#1738 by @arkid15r)
- Update US tests: Day After Thanksgiving (#1742 by @arkid15r)
- Update United Kingdom holidays: fix observed New Year's Day in Scotland (#1735 by @KJhellico)
- Update tests: use assertIsInstance (#1737 by @arkid15r)
- Fix README layout (attempt 1) (#1745 by @arkid15r)
- Add file header pre-commit check (#1744 by @arkid15r)
- Add package build tests (#1733 by @KJhellico)
- Unify file headers after recent update (#1743 by @KJhellico)

# Version 0.45

Released March 18, 2024

- Add Python 3.12 support (#1721 by @arkid15r)
- Add Kuwait holidays (#1707 by @arkid15r)
- Add Seychelles holidays (#1728 by @PPsyrius)
- Fix SonarCloud security hotspots (#1718 by @arkid15r)
- Fix SonarCloud security hotspots (attempt #2) (#1720 by @arkid15r)
- Fix SonarCloud security hotspots (attempt #3) (#1723 by @arkid15r)
- Update Mexico holidays (#1722 by @KJhellico)
- Update pre-commit config (#1732 by @KJhellico)

# Version 0.44

Released March 4, 2024

- Update Ethiopia holidays (#1704 by @KJhellico)
- Update RELEASE.rst (#1698 by @arkid15r)
- Update Ukrainian translations (proper apostrophe) (#1714 by @KJhellico)
- Update make clean action: delete docs autosummary (#1711 by @arkid15r)
- Update snapshots: Portugal holidays (#1709 by @PPsyrius)
- Update test coverage to 100% (#1715 by @KJhellico)
- Add AUTHORS file (#1700 by @arkid15r)
- Add `UNOFFICIAL` category for the United States (#1669 by @PPsyrius)
- Rename repository branches (#1699 by @arkid15r)

# Version 0.43

Released February 19, 2024

- Introduce subdivisions aliases (#1662 by @sphh, @arkid15r)
- Update Ireland holidays (#1687 by @KJhellico)
- Update Portugal holidays: fix Carnival date (#1694 by @DgRosa)
- Update Taiwan holidays (#1688 by @KJhellico)
- Update Thailand holidays: add Bridge Public Holiday on Apr 12, 2024 (#1690 by @PPsyrius)

# Version 0.42

Released February 5, 2024

- Add Ghana holidays (#1639 by @JerryAgbesi, @arkid15r)
- Add Jersey holidays (#1664 by @PPsyrius)
- Update Costa Rica holidays (#1657 by @KJhellico)
- Update Croatia holidays (#1659 by @KJhellico)
- Update Greece holidays (#1663 by @KJhellico)
- Update Switzerland holidays (#1648 by @KJhellico)
- Update United Arab Emirates holidays (#1667 by @KJhellico)
- Update ruff config (#1684 by @KJhellico)
- 2020 China calendar discrepancies fix (#1645 by @PPsyrius)
- Add United Kingdom's Whit Monday holidays for pre-1971 years (#1668 by @PPsyrius)
- Ruff cleanup (#1680 by @PPsyrius, @arkid15r)
- Unify common holidays name translation (#1673 by @KJhellico)
- Use current version for release notes generation (#1661 by @arkid15r)
- Use ruff instead of black+flake8 (#1671 by @arkid15r)

# Version 0.41

Released January 15, 2024

- Introduce observed_estimated_label (#1633 by @arkid15r)
- Refactor Thai calendar (#1628 by @KJhellico)
- Update Portugal holidays: add uk localization (#1616 by @KJhellico)
- Fix dev env setup issues (#1627 by @peter-ni-noob)
- Update Argentina holidays (#1641 by @KJhellico)
- Update China holidays: add observed and substituted holidays in 2001-2024 (#1613 by @KJhellico)
- Update Cyprus holidays (#1632 by @KJhellico)
- Update Malaysia holidays (#1625 by @shahonseven, @arkid15r)
- Update Paraguay holidays (#1634 by @KJhellico)
- Update Thailand holidays (#1626 by @PPsyrius)
- Update US holidays: add CO Cesar Chavez Day (#1629 by @nwithan8)
- Update Uzbekistan holidays, add l10n support (#1622 by @KJhellico)
- Update common tests (#1637 by @arkid15r)
- Update estimated label uk l10n (#1635 by @arkid15r)
- Document the release process (#1611 by @arkid15r)
- Implement en_US localization for all localized countries (#1614 by @KJhellico)
- Move RELEASE.rst to upper level (#1623 by @arkid15r)
- Refresh snapshots, reformat th/cn.po (#1631 by @arkid15r)
- Simplify estimated label text (#1615 by @KJhellico)
- Unify observed labels format (#1636 by @arkid15r)

# Version 0.40

Released January 1, 2024

- Refactor Germany special holidays (#1595 by @KJhellico)
- Add Papua New Guinea holidays (#1605 by @PPsyrius)
- Fix United States and Guam holidays (#1607 by @KJhellico)
- Fix inconsistent localization team naming in .po files (#1602 by @PPsyrius)
- Update IL snapshot (#1608 by @arkid15r)
- Update Kazakhstan: fix URL escaping (#1619 by @heikkiorsila, @arkid15r)
- Update README: fix shields style (#1620 by @arkid15r)
- Update Spain holidays, add l10n support (#1610 by @KJhellico)
- Update Taiwan holidays, add l10n support (#1600 by @PPsyrius)
- Extend native holiday categories support (#1597 by @arkid15r)

# Version 0.39

Released December 18, 2023

- Refactor holiday categories handling (#1584 by @arkid15r)
- Update Azerbaijan holidays, add l10n support (#1579 by @KJhellico)
- Update Israel holidays (#1557 by @arkid15r)
- Update Laos and Thailand special observed holidays (#1587 by @KJhellico)
- Update Makefile: fix snapshot generation process (#1594 by @arkid15r)
- Update NYSE holidays: fix New Year's Day observed (#1585 by @KJhellico)
- Update Netherlands holidays: fix Liberation Day (#1592 by @KJhellico)
- Update Singapore 2024 holidays (#1588 by @KJhellico)

# Version 0.38

Released December 4, 2023

- Add categories and subdivisions support to special observed holidays (#1561 by @KJhellico)
- Add categories and subdivisions support to substituted holidays (#1558 by @KJhellico)
- Update Czechia holidays: add sk localization (#1568 by @jose1711, @arkid15r)
- Update PR template and contributing guidelines (#1574 by @arkid15r)
- Update documentation: add supported entities section (#1564 by @arkid15r)
- Update snapshot generator: group holidays by subdiv (#1578 by @KJhellico)
- Update test coverage to 100% (#1573 by @arkid15r)
- Add supported categories validation (#1576 by @arkid15r)
- Merge substituted holidays with special holidays (#1580 by @KJhellico)
- Migrate South Korea holidays to ObservedHolidayBase (#1560 by @KJhellico)
- Prepare project for Weblate integration [UA] (#1565 by @arkid15r)

# Version 0.37

Released November 20, 2023

- Update Japan holidays: add th localization (#1545 by @PPsyrius)
- Fix Brazil subdivisions holidays (#1562 by @KJhellico)
- Update Denmark holidays: add holiday categories (#1555 by @KJhellico)
- Update Hungary holidays: add substituted holidays (#1551 by @KJhellico)
- Update Israel holidays (#1541 by @KJhellico)
- Update Netherlands holidays: add holiday categories (#1552 by @KJhellico)
- Update Slovakia holidays (#1546 by @jose1711)
- Update South Korea holidays, add l10n support (#1536 by @PPsyrius)
- Update Spain holidays in 2024 (#1537 by @KJhellico)
- Update Turkey holidays: add holiday categories and l10n support (#1556 by @KJhellico)
- Update Ukraine holidays (#1547 by @KJhellico)
- Update badges in README (#1544 by @kasya)
- Add `_next_year_new_years_day` to InternationalHolidays (#1539 by @KJhellico)
- Extend HolidayBase::categories to accept a single value (#1550 by @arkid15r)
- Migrate NYSE holidays to ObservedHolidayBase (#1548 by @KJhellico)

# Version 0.36

Released November 6, 2023

- Add special holidays per subdivisions support (#1520 by @KJhellico)
- Add special_holidays_observed support (#1535 by @KJhellico)
- Refactor Australia holidays (#1531 by @KJhellico)
- Refactor Isle of Man holidays (Tynwald Day) (#1532 by @KJhellico)
- Add Bahamas holidays (#1517 by @PPsyrius)
- Add Timor-Leste holidays (#1516 by @PPsyrius)
- Add Tonga holidays (#1534 by @PPsyrius)
- Update Portugal holidays: add holiday categories (#1529 by @KJhellico)
- Update South Africa holidays: add holiday in honor of Winning the Rugby World Cup 2023 (Dec 15, 2023) (#1538 by @KJhellico)
- Update snapshots generator (#1530 by @KJhellico)
- Add Thailand's Bridge Public Holiday on Dec 29, 2023 (#1528 by @PPsyrius)
- Migrate the remaining `special_holidays` to `StaticHolidays` class (#1519 by @PPsyrius)
- Remove hard-coding observed_rule for Bahamas (#1527 by @PPsyrius)
- Remove redundant gettext assignment (#1533 by @arkid15r)
- Set concurrency group for CI/CD jobs (#1540 by @arkid15r)
- Set pyproject.toml project version dynamically (#1525 by @arkid15r)
- Use OIDC (trusted publishers) for PyPI uploads (#1523 by @arkid15r)
- Use setdefault instead of hard-coding observed_rule and observed_since (#1521 by @BossColo)

# Version 0.35

Released October 16, 2023

- Refactor static holidays (#1509 by @arkid15r)
- Add Maldives holidays (#1508 by @kasya)
- Add Tanzania holidays (#1505 by @PPsyrius)
- Fix estimated label for multiple holiday group entities (#1512 by @arkid15r)
- Update China holidays add non-statutory holidays support, l10n, optional half-day holidays (#1491 by @PPsyrius)
- Update Thailand holidays: name change for October 13 holiday (#1493 by @PPsyrius)
- Update United States holidays: Columbus Day adjustment (#1503 by @KJhellico)
- Update documentation for holiday categories usage (#1506 by @KJhellico)
- Update pre-commit hooks automatic update workflow (#1507 by @arkid15r)
- Update project metadata: add @KJhellico to maintainers (#1501 by @arkid15r)
- Add py.typed to MANIFEST.in includes (#1498 by @arkid15r)
- Implement Tanzania `StaticHolidays` (#1513 by @PPsyrius)
- Simplify PR template (#1502 by @arkid15r)
- Standardize custom holiday classes use (#1510 by @arkid15r)

# Version 0.34

Released October 2, 2023

- Introduce holiday snapshots (#1478 by @arkid15r)
- Add Laos holidays (#1483 by @PPsyrius)
- Update Belarus holidays: add substituted holidays (#1486 by @KJhellico)
- Update ES snapshot (#1481 by @arkid15r)
- Update NYSE holidays: fix Juneteenth National Independence Day start year (#1484 by @KJhellico)
- Update Spain holidays (#1476 by @KJhellico)
- Update package configuration: migrate to pyproject.toml (#1466 by @arkid15r)

# Version 0.33

Released September 18, 2023

- Add merge queue support (#1464 by @arkid15r)
- Introduce ObservedHolidays class (#1444 by @KJhellico, @arkid15r)
- Update Algeria holidays: add fr localization (#1467 by @abh31000)
- Fix README.rst (#1472 by @KJhellico)
- Update Belgium holidays: add bank holidays (#1457 by @KJhellico)
- Update Brazil holidays: specify optional holidays (#1452 by @KJhellico)
- Update Canada holidays (#1448 by @KJhellico)
- Update Liechtenstein holidays: specify bank holidays (#1462 by @KJhellico)
- Update PR template (#1461 by @arkid15r)
- Update Thailand holidays: add holiday categories (#1346 by @PPsyrius, @arkid15r, @KJhellico)
- Update United Kingdom holidays (#1454 by @KJhellico)
- Update documentation: add language usage example to examples.rst (#1456 by @jovana, @arkid15r, @KJhellico)
- Update l10n files: fix ar, en_US headers (#1468 by @abh31000)
- Update pre commit automatic update workflow (#1469 by @arkid15r)
- Update skipIf rules for heavy tests (#1460 by @arkid15r)
- Migrate remaining countries to ObservedHolidayBase (#1463 by @KJhellico)
- Tune pre-commit auto-update workflow (#1473 by @arkid15r)

# Version 0.32

Released September 4, 2023

- Add subdivision category holidays support (#1446 by @KJhellico)
- Fix months imports (#1442 by @KJhellico)
- Improve code owners transparency (#1440 by @arkid15r)
- Update HolidayBase tests (#1447 by @arkid15r)
- Update documentation: correct inheritance example (#1438 by @arkid15r)
- Add CODEOWNERS (#1436 by @arkid15r)
- Add pre-commit hooks autoupdate workflow (#1441 by @KJhellico)

# Version 0.31

Released August 21, 2023

- Refactor HolidayBase methods (#1425 by @KJhellico)
- Add Barbados holidays (#1393 by @arjunanan6)
- Add Iran holidays (#1409 by @KJhellico)
- Add Vanuatu holidays (#1423 by @Strategos1)
- Fix Ukraine overlapping observed holidays (#1421 by @KJhellico)
- Update Barbados holidays (#1430 by @KJhellico)
- Update Saudi Arabia holidays: fix Eid al-Fitr and Eid al-Adha observance (#1414 by @KJhellico)
- Update Singapore holidays: add 2023 Polling Day (#1424 by @mborsetti)
- Update Slovenia holidays: add 2023 Solidarity Day (#1426 by @kanobi, @PPsyrius)
- Update Vanuatu holidays (#1431 by @KJhellico)
- Add l10n tests (#1420 by @arkid15r)
- Add latest Python 3.12 release to tests (#1432 by @KJhellico)
- Use holidays.groups instead of holidays.holiday_groups (#1428 by @arkid15r)
- Use typing cast for `HolidayBase::__eq__` (#1429 by @arkid15r)

# Version 0.30

Released August 7, 2023

- Introduce substituted holidays [PoC] (#1365 by @KJhellico)
- Refactor tests (#1400 by @KJhellico)
- Update Georgia holidays, add uk localization (#1398 by @KJhellico)
- Update Greece holidays: add uk localization (#1401 by @KJhellico)
- Update Morocco holidays: add fr localization (#1375 by @KJhellico)
- Update Angola holidays, add l10n support (#1379 by @KJhellico)
- Update Bolivia holidays, add l10n support (#1388 by @KJhellico)
- Update Djibouti holidays, add l10n support (#1374 by @KJhellico)
- Update Indonesia holidays, add l10n support (#1389 by @KJhellico)
- Update Japan holidays: add bank holidays (#1390 by @KJhellico)
- Update Mozambique holidays, add l10n support (#1386 by @KJhellico)
- Update South Korea holidays (#1391 by @KJhellico)
- Update Taiwan holidays (#1373 by @KJhellico)
- Update TestCase::_assertLocalizedHolidays(): add supported_categories holidays (#1376 by @KJhellico)
- Update Uruguay holidays (#1383 by @KJhellico)
- Update internal scripts (#1403 by @arkid15r)
- Update some URLs after moving to an organization (#1387 by @arkid15r)
- Add JULIAN_REVISED_CALENDAR calendar (#1380 by @KJhellico)
- Add Python 3.12.0-beta.4 environment (#1385 by @arkid15r)
- Add Special In Lieu Holiday on July 31, 2023 for Thailand (#1396 by @PPsyrius)
- Add substituted holidays test (#1384 by @KJhellico)
- Automatically convert subdivision code from int to str (#1415 by @arkid15r)
- Extend `HolidayBase::_add_holiday` family methods [PoC] (#1368 by @arkid15r)
- Finalize `HolidayBase::_add_holiday_*` family methods migration (#1416 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [b] (#1395 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [c] (#1397 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [d-f] (#1399 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [g-h] (#1402 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [i-k] (#1405 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [l-m] (#1406 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [n-p] (#1407 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [q-s] (#1410 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [t-u] (#1411 by @arkid15r)
- Use `HolidayBase::_add_holiday_*` family methods [v-z] (#1413 by @arkid15r)

# Version 0.29

Released July 17, 2023

- Refactor movable holidays (#1357 by @KJhellico)
- Add Guatemala holidays (#1364 by @aztrock)
- Add Arabic localization (#1341 by @abh31000)
- Optimize .po files update process (#1372 by @KJhellico)
- Optimize HolidayBase::get_named() method (#1366 by @KJhellico)
- Update .po files format: remove location comments (#1362 by @KJhellico)
- Update Algeria holidays: add missing file headers (#1363 by @arkid15r, @KJhellico)
- Update Eid-al-Adha 2023 exact dates (#1361 by @KJhellico)
- Update InternationalHolidays group: add May 2 and 3 (#1367 by @KJhellico)
- Update Ireland holidays: finish migration to holiday groups (#1350 by @KJhellico)
- Update United Kingdom holidays: update certain holidays start years (#1353 by @KJhellico)
- Migrate Bangladesh and Russia to holiday groups (#1371 by @KJhellico)
- Migrate Belgium and Luxembourg to holiday groups, add l10n support (#1343 by @KJhellico)
- Migrate Bulgaria holidays to holiday groups and categories (#1351 by @KJhellico)
- Migrate Croatia, Czechia and Slovenia to holiday groups, add l10n support (#1344 by @KJhellico)

# Version 0.28

Released July 3, 2023

- Add special holidays categories support (#1347 by @KJhellico)
- Introduce holiday categories support (#1320 by @KJhellico)
- Fix Marshall Islands tests warning (#1354 by @KJhellico)
- Fix common::TestCase methods (#1324 by @KJhellico)
- Optimize .py files formatting (#1332 by @KJhellico)
- Optimize .py files formatting (tests) (#1337 by @KJhellico)
- Update Baltic countries holidays, add l10n support (#1340 by @KJhellico)
- Update Bosnia and Herzegovina holidays, add l10n support (#1336 by @KJhellico)
- Update PR template (#1330 by @arkid15r)
- Update configuration files (#1327 by @arkid15r)
- Add HolidayBase methods for relative weekdays calculation (#1334 by @KJhellico)
- Clean up calendars (#1349 by @arkid15r)
- Drop Python 3.7 support (#1326 by @arkid15r)
- Migrate Ireland holidays to holiday groups (#1333 by @KJhellico)
- Migrate Madagascar to holiday groups, add l10n support (#1335 by @KJhellico)
- Migrate Malta to `holiday_groups`, add l10n support (#1338 by @PPsyrius, @arkid15r)
- Migrate Marshall Islands to `holiday_groups` (#1342 by @PPsyrius)
- Migrate United States holidays to holiday groups and subdivision holidays methods (#1331 by @KJhellico)
- Remove redundant `#noqa E501` labels (#1322 by @PPsyrius)

# Version 0.27.1

Released June 21, 2023

- Fix HolidayBase::pop_named partial holiday names removal (#1325 by @arkid15r)

# Version 0.27

Released June 19, 2023

- Refactor HolidayBase::pop_named (#1306 by @arkid15r)
- Refactor `_add_observed()` methods (#1282 by @KJhellico)
- Refactor common::TestCase methods (#1308 by @arkid15r)
- Refactor common::TestCase::assertLocalizedHolidays (#1315 by @arkid15r)
- Refactor holiday groups (#1295 by @arkid15r)
- Add Brunei Darussalam holidays (#1168 by @PPsyrius, @arkid15r)
- Add Burkina Faso holidays (#1278 by @KJhellico)
- Add Cambodia holidays (#1294 by @PPsyrius)
- Add Chad holidays (#1279 by @KJhellico)
- Improve calendars and special holidays readability (#1296 by @arkid15r)
- Update .py files formatting (#1297 by @arkid15r)
- Update Argentina holidays: fix movable holidays prior to 2010 (#1258 by @PPsyrius)
- Update United Kingdom holidays (#1316 by @KJhellico)
- Add Columbus day to InternationalHolidays (#1256 by @PPsyrius)
- Add Isle Of Man 1970 test (#1304 by @arkid15r)
- Add `_add_childrens_day(...)` to `InternationalHolidays` (#1300 by @PPsyrius)
- Allow using ISO 639-2 (three-letter) language codes (#1313 by @arkid15r)
- Clean up configuration files (#1318 by @arkid15r)
- Make Tynwald Day movable from 1992 onwards for Isle of Man (#1310 by @PPsyrius)
- Migrate Angola holidays to holiday groups (#1276 by @kasya)
- Migrate Aruba to holiday groups (#1303 by @PPsyrius, @arkid15r)
- Migrate Colombia to holiday groups (#1259 by @PPsyrius)
- Migrate Curaçao to holiday groups (#1309 by @PPsyrius, @arkid15r)
- Migrate Hungary to holiday groups, add l10n support (#1311 by @KJhellico)
- Migrate LATAM countries to holiday groups (#1312 by @KJhellico)
- Migrate South Africa holidays to holiday groups (#1301 by @KJhellico)
- Migrate remaining countries to custom calendar types (#1277 by @KJhellico)
- Migrate some African countries to holiday groups (#1302 by @KJhellico)
- Run entity import tests on latest Python version only (#1305 by @arkid15r)
- Use aware UTC datetimes internally (#1314 by @scop)

# Version 0.26

Released June 5, 2023

- Add estimated_label localization support to Asian holiday groups (#1229 by @KJhellico)
- Introduce Asian holidays pre-calculated data (#1148 by @KJhellico)
- Refactor calendars: optimize inheritance and scope (#1251 by @arkid15r)
- Refactor common::TestCase (#1221 by @arkid15r)
- Refactor existing utils methods, add list localized entities methods (#1185 by @arkid15r)
- Refactor long running tests (#1182 by @KJhellico)
- Add Belize holidays (#1181 by @KJhellico)
- Add Cameroon holidays (#1243 by @KJhellico)
- Add El Salvador holidays (#1198 by @KJhellico)
- Add Gabon holidays (#1244 by @KJhellico)
- Update Azerbaijan holidays: use custom Islamic calendar (#1231 by @KJhellico)
- Update ChineseCalendarHolidays: add Ching Ming Festival (#1240 by @KJhellico)
- Update Greece holidays: add Good Friday (#1257 by @KJhellico)
- Update Morocco holidays (#1205 by @abh31000)
- Update README supported country table format (#1241 by @arkid15r)
- Update Singapore tests: cover non-observed holidays (#1184 by @arkid15r)
- Update South Korea holidays: add alternative holidays for Birthday of the Buddha and Christmas Day (#1249 by @DiceMono)
- Update Vatican City holidays (#1206 by @KJhellico)
- Update Vatican City holidays: add Saint Joseph the Worker's Day introduction year check (#1242 by @PPsyrius)
- Update calendar naming: fix grammar (#1220 by @arkid15r)
- Update l10n related workflows (#1140 by @arkid15r)
- Update test coverage: fix uncovered lines (#1250 by @arkid15r)
- Add Asian calendars classes code generator (#1219 by @KJhellico)
- Add EntityLoader inheritance error message (#1208 by @arkid15r)
- Add Hebrew calendar class code generator (#1222 by @KJhellico)
- Add St. James' and St. George's days to ChristianHolidays (#1230 by @KJhellico)
- Migrate Botswana holidays to holiday groups (#1207 by @KJhellico, @arkid15r)
- Migrate Cuba holidays to holiday groups (#1245 by @PPsyrius)
- Migrate Kenya holidays to holiday groups (#1246 by @PPsyrius)
- Migrate Montenegro holidays to holiday groups (#1248 by @kasya)
- Migrate New Zealand holidays to holiday groups and subdivision holidays methods (#1212 by @KJhellico)
- Migrate San Marino holidays to holiday groups (#1247 by @kasya)
- Migrate United Kingdom holidays to holiday groups and subdivision holidays methods (#1213 by @KJhellico)
- Migrate financial to holiday groups (#1174 by @arkid15r)

# Version 0.25

Released May 15, 2023

- Introduce entity lazy loading, #1087 (@arkid15r)
- Add Algeria holidays, #1176 (@abh31000)
- Update Andorra holidays: fix AD-08 holiday, #1149 (@KJhellico)
- Update Canada holidays localization: fix `th` tests and translation, #1147 (@PPsyrius)
- Update Chile tests, #1150 (@KJhellico)
- Update Russia holidays: add 2023 bridge holidays, #1142 (@leeloo-1337)
- Update Slovakia holidays, localization, #1169 (@KJhellico)
- Update Thailand tests: add special holidays, #1167 (@PPsyrius)
- Update holiday groups: extend Easter methods, #1136 (@arkid15r)
- Add Islamic calendar class code generator, #1128 (@KJhellico)
- Add release notes generator, #1129 (@arkid15r)
- Migrate Brazil holidays to holiday groups and subdivision holidays methods, #1137 (@KJhellico)
- Migrate Slovakia holidays to holiday groups, #1143 (@kasya)
- Reorder HolidayBase methods, #1175 (@arkid15r)
- Unify code structure for Malaysia and Singapore, #1134 (@arkid15r)
- Use a method per subdivision approach for [a-i] countries, #1133 (@arkid15r)

# Version 0.24

Released May 1, 2023

- Introduce Islamic holidays pre-calculated data, #1090 (@KJhellico)
- Introduce Israel holidays pre-calculated data , #1104 (@KJhellico)
- Refactor calendars, introduce calendar customization, #1122 (@arkid15r)
- Refactor country subdivisions, #1114 (@arkid15r)
- Refactor weekday helpers: extend args to accept month/day tuple, #1112 (@arkid15r)
- Optimize CI/CD stages, #1121 (@KJhellico)
- Update Ukraine holidays: fix May 2021 observed holidays, #1113 (@arkid15r)
- Update coverage upload process, #1131 (@arkid15r)
- Update l10n scripts, #1100 (@arkid15r)
- Add methods for localization tests, #1106 (@KJhellico)
- Migrate Azerbaijan holidays to holiday groups, #1115 (@KJhellico)
- Migrate Indonesia holidays to holiday groups, #1117 (@KJhellico)
- Migrate Islamic holidays countries to holiday groups, #1103 (@KJhellico)
- Migrate Malaysia holidays to holiday groups, #1120 (@KJhellico)
- Migrate Saudi Arabia holidays to holiday groups, #1116 (@KJhellico)
- Migrate Singapore holidays to holiday groups, #1118 (@KJhellico)
- Migrate Thailand holidays to holiday groups, #1119 (@PPsyrius, @KJhellico)
- Switch Vietnam holidays from Korean to Chinese lunisolar calendar, #1105 (@KJhellico)

# Version 0.23

Released April 17, 2023

- Add Islamic multi-day holidays support to holiday_groups, #1086 (@KJhellico)
- Refactor Japan observed holidays, #1081 (@KJhellico)
- Refactor astronomic holidays, #1094 (@KJhellico)
- Refactor long running countries tests, #1071 (@KJhellico, @arkid15r)
- Update InternationalHolidays:_add_labour_day method, #1099 (@arkid15r)
- Update Israel holidays, #1080 (@KJhellico)
- Update utils list supported entities methods, #1043 (@arkid15r)
- Add Ecuador holidays, #1070 (@KJhellico)
- Add distribution build tests, #1085 (@arkid15r)
- Add polib as a deploy process dependency, #1077 (@arkid15r)
- Migrate Australia holidays to holiday groups and subdivision holidays methods, #1069 (@KJhellico)
- Migrate Canada holidays to holiday groups and subdivision holidays methods, #1078 (@KJhellico)
- Migrate German language countries holidays to holiday groups, #1096 (@KJhellico)
- Migrate Jamaica holidays to holiday groups, #1065 (@KJhellico)
- Migrate Mexico holidays to holiday groups, #1091 (@KJhellico)
- Migrate Netherlands holidays to holiday groups, localization, #1098 (@KJhellico)
- Migrate Scandinavian countries holidays to holiday groups, #1102 (@KJhellico)
- Migrate Spain holidays to holiday groups and subdivision holidays methods, #1072 (@KJhellico)
- Migrate Switzerland holidays to holiday groups, localization, #1097 (@KJhellico)
- Migrate Vietnam holidays to holiday groups, #1064 (@KJhellico)
- Normalize holidays dict keys type, #1084 (@arkid15r)
- Reconfigure dependabot, #1092 (@arkid15r)
- Standardize country alias tests, #1074 (@arkid15r)

# Version 0.22

Released April 3, 2023

- Introduce holiday groups, #865 (@arkid15r, @KJhellico)
- Introduce subdivision holidays methods, #1057 (@arkid15r)
- Refactor .po and .mo files generation, #1033 (@KJhellico)
- Refactor Dominican Republic movable holidays, #1046 (@KJhellico)
- Refactor South Korea holidays: optimize alternative holidays, #1054 (@KJhellico)
- Refactor common.TestCase: speed up tests, #1060 (@KJhellico)
- Fix Canada localization, #1073 (@KJhellico)
- Update Andorra parish holidays, #1036 (@KJhellico)
- Update France holidays, localization, #1055 (@KJhellico)
- Update Moldova holidays, localization, #1045 (@KJhellico)
- Update PR template: add documentation mentioning, #1041 (@arkid15r)
- Update PR template: rework tests related action item wording, #1058 (@arkid15r)
- Update README: add missing th localization for Canada, #1032 (@PPsyrius)
- Update Romania holidays, localization, #1044 (@KJhellico)
- Update Uruguay localization: fix uk translation, #1035 (@KJhellico)
- Update country/financial years tests, #1061 (@arkid15r)
- Add Costa Rica holidays, #1048 (@KJhellico)
- Extend `get_named()` lookup types: add `[i]startswith`, #1062 (@arkid15r)
- Memoize list supported entities methods results, #1042 (@arkid15r)
- Migrate Argentina holidays to holiday groups, #1051 (@PPsyrius)
- Migrate Bahrain and India holidays to holiday groups, #1047 (@arkid15r)
- Migrate Portugal holidays to holiday groups, #1050 (@PPsyrius)
- Migrate Ukraine holidays to holiday groups, #1056 (@KJhellico)
- Migrate Uruguay holidays to holiday groups, #1053 (@PPsyrius)
- Migrate Venezuela holidays to holiday groups, #1052 (@PPsyrius)
- Restore 100% test coverage, #1038 (@KJhellico)
- Unify file headers, #1039 (@KJhellico)

# Version 0.21.13

Released March 15, 2023

- Refactor NYSE holidays, #1018 (@KJhellico)
- Fix distribution build, #1028 (@arkid15r)
- Fix the documentation build warning, #1026 (@arkid15r)
- Optimize TestAllInSameYear::test_all_countries test, #1001 (@arkid15r)
- Update Canada localization: fr, #1015 (@KJhellico)
- Update Denmark holidays: remove "Store bededag" starting 2024, #1013 (@malthe)
- Update PR template, #1019 (@arkid15r)
- Update Portugal holidays, #1011 (@PPsyrius)
- Update Ukraine holidays, #1014 (@KJhellico)
- Update package build process, #1020 (@arkid15r)
- Add multiple countries localization: en_US, es, uk, #1012 (@KJhellico)
- Unify country imports order, #1003 (@arkid15r)
- Use native apostrophe for uk locale holiday names, #1004 (@arkid15r)

# Version 0.21

Released March 6, 2023

- Refactor `HolidayBase::get_named`, #991 (@arkid15r)
- Refactor calendars: extract to a separate module, #969 (@arkid15r)
- Refactor common.TestCase, #979 (@arkid15r)
- Refactor relative weekdays calculation: replace relativedelta, #1002 (@KJhellico)
- Fix NYSE New Year's Day observance calculation, #1000 (@KJhellico)
- Fix tox.ini typo, #994 (@mborsetti)
- Improve Argentina holidays, #988 (@PPsyrius)
- Optimize Azerbaijan observed holidays, #961 (@KJhellico)
- Optimize Malaysia observed holidays, #963 (@KJhellico)
- Optimize Nigeria observed holidays, #978 (@KJhellico)
- Update Argentina holidays. Add holidays localization: uk, #968 (@KJhellico)
- Update Chile holidays. Add localization: en_US, es, uk, #990 (@KJhellico)
- Update Ireland holidays: St. Bridget's Day, #953 (@PPsyrius)
- Update Japan holidays localization: en_US, #964 (@KJhellico)
- Update Mexico holidays, #980 (@KJhellico)
- Update PR template, #997 (@arkid15r)
- Update Saudi Arabia holidays, #962 (@KJhellico)
- Add Canada holidays localization: th, #986 (@PPsyrius)
- Add Colombia holidays localization: en_US, es, uk, #965 (@KJhellico)
- Add Monaco holidays localization: en_US, fr, uk, #966 (@KJhellico)
- Add Thailand holidays localization: en_US, th, #946 (@PPsyrius)
- Add functions for relative weekdays calculation, #989 (@KJhellico)
- Add tox-ini-fmt to .pre-commit-config.yaml, #999 (@arkid15r)
- Clean up Malaysia tests, #996 (@KJhellico)
- Clean up Thailand localization and in-line code comments, #995 (@PPsyrius)
- Clean up tests module loading, #992 (@arkid15r)
- Use the built-in library for time zone functions, #993 (@mborsetti)

# Version 0.20

Released February 23, 2023

- Add localization support, #827 (@arkid15r, @bkthomps, @dragoon)
- Introduce `HolidayBase::_is_leap_year()`, #886 (@arkid15r)
- Introduce `HolidayBase::_is_monday` - `HolidayBase::_is_sunday` helper methods, #841 (@arkid15r)
- Refactor Burundi holidays, #925 (@KJhellico)
- Refactor Cuba holidays, #927 (@KJhellico)
- Refactor HolidayBase class and utils, #815 (@arkid15r)
- Refactor common.TestCase, #926 (@arkid15r)
- Refactor days offset calculation for recently added countries, #924 (@KJhellico)
- Refactor days offset calculation: replace `relativedelta` with `timedelta` (tests), #901 (@arkid15r)
- Refactor days offset calculation: replace `relativedelta` with `timedelta`, #900 (@arkid15r)
- Refactor implicit returns, #935 (@arkid15r)
- Add Panama holidays, #916 (@KJhellico)
- Localize ascii incompatible countries, #955 (@arkid15r)
- Change holiday name separator from ", " to "; ", #922 (@arkid15r)
- Fix Hong Kong, #928 (@KJhellico)
- Fix Islamic holidays calculation, #914 (@KJhellico)
- Fix Thailand related changes coverage decrease, #942 (@arkid15r, @PPsyrius)
- Fix Ukraine tests, #943 (@KJhellico)
- Fix readthedocs.io build, #973 (@arkid15r)
- Improve Thailand holidays, #929 (@PPsyrius, @arkid15r, @KJhellico)
- Optimize Botswana observed holidays, #932 (@KJhellico)
- Optimize Burundi observed holidays, #933 (@KJhellico)
- Optimize Montenegro: observed holidays, #908 (@KJhellico)
- Optimize Ukraine observed holidays, #934 (@KJhellico)
- Optimize observed holidays, part 1, #949 (@KJhellico)
- Optimize observed holidays, part 2, #952 (@KJhellico)
- Update Albania observed holidays, #950 (@KJhellico)
- Update Australia holidays: fix 2020 QLD holidays, #923 (@arkid15r)
- Update Bolivia holidays, #910 (@KJhellico)
- Update Bosnia and Herzegovina holidays, #909 (@KJhellico)
- Update Canada holidays (add National Day for Truth and Reconciliation in British Columbia), #951 (@KJhellico)
- Update Jamaica holidays, #913 (@KJhellico)
- Update PR template, #960 (@arkid15r)
- Update Poland holidays, add uk localization, #947 (@KJhellico)
- Update dev/test environments, #930 (@arkid15r)
- Upgrade dependency: change black version from 22.12.0 to 23.1.0, #921 (@arkid15r)
- Upgrade pre-commit config: mypy v1.0.1, #970 (@arkid15r)
- Add GitHub pull request template, #911 (@arkid15r)
- Add International Women's Day for DE-MV, #936 (@alexanderschulze)
- Add Marshall Islands (ISO-3666-1 code MH), #937 (@mborsetti)
- Add Northern Mariana Islands (ISO-3666-2 code US-MP), #939 (@mborsetti)
- Add United States Minor Outlying Islands (ISO-3666-2 code US-UM), #940 (@mborsetti)
- ISO 3166-1 for US subdivisions, #941 (@mborsetti, @dr-prodigy)
- Rename dev env setup target, #944 (@arkid15r)
- Suppress warnings for tests, #945 (@arkid15r)

# Version 0.19

Released January 30, 2023

- Copyright update 2023
- Added Arkadii Yakovets (@arkid15r) to project collaborators / maintainers - welcome!
- Add supported countries tests #878 (@arkid15r)
- Update tox configuration #881 (@arkid15r)
- Use augmented assignment statements #890 (@arkid15r)
- Clean up timedelta/relativedelta usage #892, #894 (@arkid15r)
- Add Albania initial support #895 (@arkid15r)
- Add Andorra initial support #896 (@arkid15r)
- Add Bahrain initial support #888 (@arkid15r)
- Add Montenegro initial support #897 (@arkid15r)
- Add San Marino initial support #898 (@arkid15r)
- Add Vatican City initial support #904 (@arkid15r)
- Add Monaco holidays #877 (@KJhellico)
- Migrate prophet.hdays countries #887 (@arkid15r)
- Dominican Republic fix Corpus Christi holiday, tests refactoring #906 (@KJhellico)
- Japan: substitute holidays and citizens' holidays calculation #879 (@KJhellico)
- Singapore holidays update #880 (@KJhellico)

# Version 0.18

Released December 27, 2022

- Code refactoring #801, #870 (arkid15r)
- Test refactoring / common functions #800, #830, #844 (arkid15r)
- Pre-commit reviews #786, #795 (KJhellico, arkid15r, dr-p)
- Import cleanup, flake8 settings review #792 (arkid15r, KJhellico, dr-p)
- PyMeeus for equinox and solstice calculation #828, #863 (Nalguedo)
- Easter holidays refactoring and unification #803 (KJhellico)
- Observed holidays calc optimizations #824 (KJhellico)
- Special holidays refactoring for 13 countries #796 (arkid15r, KJhellico)
- Support for Indonesia #787 (KJhellico)
- Support for Pakistan #847 (KJhellico)
- Support for Armenia #875 (KJhellico)
- Korea renamed to South Korea #797 (arkid15r)
- Azerbaijan: refactoring #859 (KJhellico)
- Hong Kong: optimizations #786 (KJhellico)
- Korea fixes #791 (KJhellico) + test optimizations (dr-p)
- Zambia: optimizations and refactoring #798 (KJhellico)
- Vietnam: optimizations and refactoring #799 (KJhellico)
- Malaysia: optimizations, refactoring and fixes #802, #858 (KJhellico)
- New Zealand: optimizations and refactoring #836 (KJhellico)
- Chile: optimizations #834 (KJhellico) + fixes #828 (Nalguedo)
- Uruguay updates #809 (KJhellico)
- Kazakhstan updates #829, #867 (KJhellico)
- Canada fixes #811 (jasonjensen)
- Nigeria updates #823 (KJhellico)
- NY Stock Exchange updates #817, #853 (SnowX65, KJHellico)
- New Zealand optimizazions #872 (KJhellico)
- Madagascar updates #818 (KJhellico)
- Paraguay updates #819 (KJhellico)
- United Kingdom updates #840 (KJhellico)
- South Africa: optimizations and updates #820, #848 (KJhellico)
- US updates #857 (KJhellico)
- Switzerland: optimizations, fix #821 (KJhellico)
- Angola: optimizations, fix #822, #835 (KJhellico)
- India updates #825 (KJhellico)
- NY Stock Exchange updates #833 (SnowX65, KJhellico)
- Hungary fixes #826 (KJhellico)

# Version 0.17.2

Released November 23, 2022 - Swaziland deprecation warning fix #794 (arkid15r)

First release (0.17) November 13, 2022

- 100% test coverage, code refactoring #747, #749 (arkid15r)
- Special holidays (one-off) support #724 (arkid15r, dr-p)
- Support for Bosnia and Herzegovina #683, #725 (kasya, arkid15r)
- Support for Liechtenstein #650, #728, #758 (kasya, arkid15r)
- Added isort to pre-commit #722, #734 (arkid15r, dr-p)
- Get item multiple return type fix (dr-p) TODO: possible refactor required
- Sort overlapping holiday names #713 (kasya, arkid15r)
- Supported country / financial lists fix #764 (arkid15r)
- Various refactorings #777 (arkid15r)
- Various refactorings #756, #759, #760, #766, #767, #770, #775, #776, #780 (KJhellico)
- Portugal improvements #753 (Nalguedo)
- Brazil improvements #761, #592 (Nalguedo)
- Uruguay improvements #758 (kasya)
- Hong Kong improvements #779, #782 (poshingchu)
- Swaziland deprecation, replaced by Eswatini #721 (bkthomps)
- Norway, Sweden rework #771 (arkid15r)
- South Africa rework #773 (KJhellico)
- Singapore fixes #717, #726, #754, #782 (amas01, mborsetti, kasya, poshingchu)
- Canada fixes #715, #733 (bkthomps, MichaelThessel)
- Honduras fixes #720, #744 (bkthomps, arkid15r)
- Japan upgrades (added substitute holidays) #723 (shohirose)
- Malaysia fix #736, #782 (shahonseven, poshingchu)
- Ukraine fixes #743, #746 (KJhellico)
- Bulgaria fixes #748 (KJhellico)
- Isle of Man fix #762, #764 (arkid15r)
- Lithuania fix #781 (Nalguedo)
- Sweden fix #783 (sander-visser, KJhellico)

# Version 0.16

Released September 16, 2022

This release is dedicated to Queen Elizabeth II (21 April 1926 -- 8 September 2022), who lived her long life as a monarch through 2 centuries, in both happy and difficult moments, with grace, dignity and an always inspiring strong sense of duty and warm heart. Goodbye "Lilibet", you have symbolically been a queen, a mother and a grandmother to a lot of us, and will be dearly missed.

- Financial market support review, new method financial_holidays(..) #694 (dr-p)
- Support for Moldova #695 (Thedand)
- Support for Bolivia #679, #698 (kasya)
- UK updates #702 (JPunter, violuke)
- Australia updates #699 (Ryan-McCrory, dr-p)
- Canada updates #710 (bkthomps)
- New Zealand updates #708, #709 (dr-p, markhoneth)
- NYSE updates #693, #696 (kasya)

# Version 0.15

Released August 21, 2022

- Added support for Python3.11 (dr-p)
- Updated README - improved badges area (dr-p)
- Support for Cuba #678 (bthompson, dr-p)
- Typechecking implementation, first release (HolidayBase, utils, some sample countries) #661 (dimbleby)
- Test coverage improvement #633 (akosfurton, dr-p)
- Drop support for UK subdivisions as countries (England, Scotland..) (dr-p)
- Drop support for IsleOfMan as UK subdivision (dr-p)
- Drop support for PortugalExt (ie: extended Portugal) (dr-p)
- US fixes #675 (arkid15r)
- Colombia fixes & test improvements #676 (bkthomps)
- Venezuela fixes & test improvements #677 (bkthomps)
- Canada fixes #579 (dr-p, scubaandre)
- Ukraine refactoring #681 (kasya)
- Italy update #689 (g-gg, dr-p)
- Bump pre-commit and setup-python actions #672, #682, #686, #688 (dr-p)
- Doc example fix #685 (steakhutzeee, dr-p)

# Version 0.14.2

Released June 5, 2022

- Drop support for EOL Python 3.6 #328 (hugovk, dr-p)
- Package review #662 (dimbleby)
- Added financial markets support: ECB and NYSE, list_supported_financial() method (dr-p)
- Support for NY Stock Exchange #651, #458 (nadime, dr-p)
- Support for Malta #612, #630 (rafelbev)
- Support for Madagascar #656 (fav007)
- Support for Cyprus #410, #665 (digidestination, avnigo)
- Ireland as standalone country #636, #639 (TeoTN, dr-p, javicalle)
- Australia fixes #631 (jeremychrimes)
- Singapore updates #652 (mborsetti)
- Saudi Arabia fixes #642 (OsaydAbdu)
- Spain fixes #634 (javicalle)
- US fixes #648 (dashdrum)
- Greece fixes #659 (tudorvaran)
- India doc fixes #657 (dr-p)
- Poland fix #663 (kfsz)

# Version 0.13

Released February 15, 2022

- New subdivision parameter (subdiv), prov/state deprecation #608, #597, #374 (mborsetti)
- CountryHoliday class deprecation (replaced by country_holidays) (mborsetti, dr-p)
- Sphinx documentation #600, #601, #602 (mborsetti)
- Integration of mypy in pre-commit #620 (mborsetti)
- Wrong year expansion fix #586, #606, #625 (mborsetti, TeejMonster, dr-p)
- Refactoring / cleanups / code and naming reviews (mborsetti)
- Support for Uzbekistan #593 (slako, dr-p)
- Italy fixes/improvements #617, #614 (energywave)
- Spain improvements #580, #603, #624 (gtrabanco, delaosa, dr-p)
- UAE updates (weekend change) #609 (marcomasulli, dr-p)
- India updates #548 (mborsetti)
- US fixes #594, #595, #619 (apicht, SudoRob, dr-p)
- UK fixes #587 (mborsetti)
- Russia fixes #582 (Enzokot)
- Type hints fixes #589 (mborsetti)

# Version 0.12

Released January 4, 2022

- Copyright update 2022
- Sphinx documentation stub (mborsetti, dr-p)
- Support for Kazakhstan #534 (chiuczek, intelliHugh)
- Support for Azerbaijan #540 (eldar-mustafayev)
- Support for Tunisia #543 (ihebski)
- Support for Taiwan #547 (ifurther)
- Support for North Macedonia #570 (tserekh)
- Support for Ethiopia #558 (tedtad, dr-p)
- Travis CI removal #557 (mborsetti, dr-p)
- CD/CI tests - Pypi versions review (dr-p)
- More useful `__repr__` and `__str__` #360 (dr-p, kootenpv, d33tah)
- Drop support for Czech (ie: misspelled Czechia) (dr-p)
- Drop support for Polish (ie: misspelled Poland) (dr-p)
- Drop support for Slovak (ie: misspelled Slovakia) (dr-p)
- Test coverage improvement (dr-p)
- "country" property moved to class attributes #573 (dr-p, madphysicist)
- Date slices support fix #529, #530 (justinwaf, mborsetti, dr-p)
- Dictionary changed during iteration fix #569 (mborsetti)
- Doc fixes #549 (canute24)
- UK standalone states deprecation #566 (dr-p)
- Venezuela ISO code + other fixes #567, #576 (Skatox, dr-p, antusystem)
- Canada updates and test review #533, #536 (cturra)
- US updates and fixes #537, #559, #578 (khawley, evohnave, amelkiy, dr-p)
- India fixes #553, #554, #539 (canute24, dr-p)
- Spain fixes #555 (tserekh)
- Italy fixes #546 (dr-p, rtraverso86)
- Korea fixes #535 (0xF4D3C0D3)
- Colombia fixes #564 (jahirfiquitiva)

# Version 0.11.3.1

Released September 29, 2021

- Support for Zambia #495, #496 (engineervix)
- Support for Uruguay #489, #490, #491, #492, #493 (jemazzeo, dr-p)
- Support for Lesotho #512 (pietervdw115)
- Support for Namibia #513 (pietervdw115)
- Support for Swaziland #514 (pietervdw115)
- Support for Zimbabwe #517 (pietervdw115)
- Support for China #515 (tserekh)
- Refactor lunisolar and islamic calendar #524 (mborsetti)
- Removed six dependency #494 (mborsetti)
- Type hinting #497, #498 (mborsetti)
- Malaysia refactoring & updates #524 (mborsetti)
- New Zealand updates #499 (36wish)
- USA, Angola fixes (jusce17)
- Kenya updates #502 (MainaKamau92)
- Korea updates #508 (0xF4D3C0D3, dr-p)
- Bulgaria updates #509 (BasakUlker, dr-p)
- Australia updates #516 (cmckeague)
- South Africa updates (lispwarez, dr-p)
- Canada updates #457 (dr-p)
- PRTE (PortugalExt) fix #520 (dr-p)
- Norway updates #472 (dr-p)
- Chile updates #473 (dr-p)
- Australia updates #525 (jeremychrimes)
- README iso codes typo / improvements #520 (dr-p)
- .gitattributes fix #522 (mborsetti)

# Version 0.11.2

Released July 18, 2021

- Support for Venezuela #470 (antusystem, dr-p)
- Support for Botswana #477 (pietervdw115)
- Support for Malaysia #466 (jusce17) *needs improvement*
- Poland fix #464 (m-ganko)
- Singapore updates for 2022 #456 (mborsetti)
- US updates #474, #488 (ChristianAlexander, jusce17)
- NG updates #486 (pietervdw115)
- UK updates #487 (orrock, dr-p)
- .gitignore fix #462 (TheLastProject)
- Pre-commit v.2.0.3 (dr-p)

# Version 0.11.1

Released April 2, 2021

- Github Actions CI/CD integration (s-weigand, dr-p)
- Support for Saudi Arabia #429 (OsaydAbdu)
- Support for Curacao #431 (RaychelM, dr-p)
- Support for Jamaica #433 (edyarm, dr-p)
- Support for Georgia #435 (Okroshiashvili, dr-p)
- `__init.py__` flake8 issue fix #423 (dr-p)
- Korea 2020 fix #414, #415 (dr-p, janggiKim, spar7453)
- Singapore fix for multi-year #419 (mborsetti)
- Israel fix #442 (giladmaya)
- Japan fix #445 (osoken)
- Serbia fix #446 (kosugor)
- United Kingdom get_list fix #448 (bletham)
- Singapore fix for multi-year #419 (mborsetti)
- Fixed holidays pickling #451 (giladmaya)

# Version 0.10.5.2

Released February 4, 2021

- Dropped support for Python 2 (dr-p)
- Removed convertdate<=2.2.0 constraint (dr-p)
- Travis CI integration review (dr-p)
- Support for Mozambique (jusce17)
- Angola fixes (jusce17)
- Portugal localized holidays (jusce17)
- Disable year expansion on name search #411 (giladmaya)
- Israel fixes (new convertdate version) #407 (giladmaya)
- Ireland fixes (ISO-2 code, partial split from UK) #417 (javicalle)
- Honduras fix (ISO-2 code) #405 (dr-p, agorajek)

# Version 0.10.4

Released December 6, 2020

- Dropped support for Python 3.5
- Support for Djibouti (Abdisamade)
- Support for United Arab Emirates (marcomasulli, mborsetti)
- Support for Chile (mborsetti, dr-p)
- Support for Angola (jusce17, pietervdw115, dr-p)
- Support for Malawi (pietervdw115)
- Support for Bangladesh (dr-p, tasnimislam)
- Korea fixes (MYUNGJE, dr-p, hiddentrap)
- Australia 2020 fix (bencollerson, trauty-is-me)
- Croatia fixes and updates (jangrg, mborsetti, dr-p)
- United States fixes (raffg, bgmiles, dr-p)
- UK fixes/improvements (dr-p, richard-kunert, emreay-)
- Russia fixes (tserekh)
- Ireland fixes (chiuczek)
- Spain observed holidays fix (sermayoral)
- South Africa observed holidays fix (pietervdw115)
- France fix (mborsetti)
- Mexico fix (mborsetti)
- Singapore 2022 fix (mborsetti)
- Japan 1990-1993 fixes (sakurai-youhei)
- Fix on occasional pop_named exception (mborsetti)
- convertdate fallback if hijri-converter not available (mborsetti, dr-p)
- enabled Travis tests for python3.9 (mborsetti)
- added flake8 to unittests (mborsetti)

# Version 0.10.3

Released July 15, 2020

- Added get_named(substring) method to retrieve holidays by name (dr-p)
- Added pop_named(substring) method to pop specific holiday/s by name (samtregar, dr-p)
- Support for Burundi (bmwachajr)
- Support for Latvia (rolandinsh)
- Support for Romania (dorianm)
- Spain fix (dr-p)
- Netherlands fix (RooieRakkert)
- Switzerland fixes (cgrigis)
- Germany fix (MikeTsenatek)
- Added korean_cal attribute to Korea and Vietnam (seriousran, pelennor)
- United States fixes (patrick-nicholson, dr-p)
- Singapore fixes + 2021 holidays (mborsetti)

# Version 0.10.2

Released April 13, 2020

- Support for Spain (piliamaurizio, jbroudou, dr-p, gerardo15)
- Support for Turkey (cemkaragozlu)
- Support for Korea (1kko, dr-p)
- Support for Vietnam (1kko, dr-p)
- Support for Morocco (abensrhir, dr-p)
- Mexico fix (Rosi2143, dr-p)
- Croatia fix (sebojanko, dr-p)
- US Georgia fix (jbroudou, dr-p)
- Austria province ISO3166-2 adoption (jbroudou, dr-p)
- Portugal typos & name fixes (reinaldoramosarxi)
- US MLK renamed (snoopyjc, dr-p)
- ISO-3 codes export fix (dr-p)

# Version 0.10.1

Released January 25, 2020

- Project structure refactoring (MaxHaertwig, dr-p)
- Added support for Python3.8 (dr-p)
- Dropped support for pypy and Python3.4, welcome back pypy3 (dr-p)
- Fully reviewed Travis CI integration (dr-p)
- Added 3-digit country ISO codes (MaxHaertwig)
- Support for Paraguay (dr-p, sfeliu)
- Support for Israel (giladmaya, dr-p)
- Support for Egypt (gaberm)
- Support for Serbia (kosugor)
- Support for Singapore (mborsetti)
- README.rst fixes / sync
- Brazil-Parana support (dr-p, jbroudou)
- Japan fixes (dr-p, thophan92, saurabh3896)
- Canada, Spain, US fixes (jbroudou)
- Belarus fix (mpolyakovsky)

# Version 0.9.12

Released December 23, 2019

- Support for Nigeria (ioluwayo)
- Support for India - Telangana (kiranbeethoju, dr-p)
- Support for Dominican Republic (gabmartinez)
- Support for Nicaragua (CARocha)
- Code refactoring, bugfixes (vlt)
- Add method to list all supported countries (fabaff)
- Germany bugfixes (bitraten)
- Correctly handle United Kingdom "May Day" holiday in 2020 - #219 (robfraz)
- Hungary fixes (gypapp)
- Chile test fixes (rpanai)
- Italy fixes (jokerigno, sixbladeknife)
- Other minor fixes

# Version 0.9.11

Released July 28, 2019

- Added Japanese holidays for new Emperor (kokinamura)
- Fixed Australian Canberra day holiday (explodingdinosaurs, dr-p)
- Added support for Estonian holidays (RaulVS14)
- Added support for Iceland and Kenya (justinasfour04)
- Added support for Aruba (orson1282)
- Added support for Hong Kong (polifaces)
- Added support for Peru (manuelvalino)
- Switzerland fixes (spasche)
- Croatia fix (pave121, dr-p)
- Polish deprecation: replaced by Poland (dr-p)
- Czech(ia) - Slovak(ia) fixes (dr-p)
- Allow passing years to CountryHoliday (mr.shu)

# Version 0.9.10

Released March 12, 2019

- Added Lithuanian holidays support (GiedriusMauza)
- Added Luxembourgish holidays (theFeverDog)
- Added Russian holidays (mshinkareva)
- Added Bulgarian holidays (pavelsof)
- Holidays in date range (elln2)
- German holidays updates (MrtnBckr, alexanderschulze)
- South African holidays updates (nickyspag)
- Australian holidays updates (itssimon)

# Version 0.9.9

Released January 3, 2019

- Magic numbers removal (elln2, dr-p)
- Honduras support (Oscar Romero)
- Brazil's holidays fixes (victorpluna)
- Added provinces and holidays in Italy (krolmic, dr-p)
- Fixed regression with German Easter and Pentecost holidays (vlt, Achimh3011)
- Fixed Canada Holiday Calendar (justinasfour04)
- Fixed Columbus Day in Arkansas - US (johanneshk)
- Added Grand Final Day in Victoria - AU (isha1111)
- Added Palm Sunday to Danish holidays (jmkjaer)
- South Africa's holidays fixes (Gordonei)

# Version 0.9.8

Released October 18, 2018

- Added Ukraine (Anian-igor)
- Added Croatia (fran1987)
- Added Brazil (fcrespo82)

# Version 0.9.7

Released September 12, 2018

- Added prov/state parameters to CountryHoliday() (luto)
- Added Python 3.7 compatibility (required dateutil >= 2.7.0)
- Fixed German Reformationstag (adaitche, Rosi2143), various other holiday updates
- Added Belarus (Gennady-Andreyev)

# Version 0.9.6

Released August 1, 2018

- Added India (Shaurya Uppal)
- Fixed Canadian holidays (Canada / Dominion Day)
- Fixed German holidays (Buß- und Bettag, Ostern, Pfingsten)

# Version 0.9.5

Released April 23, 2018

- Added Hungary (Peter Zsak)
- Added Argentina (Emmanuel Arias)

# Version 0.9.4

Released March 12, 2018

- Added CountryHoliday(country_name) method
- Added Switzerland with all cantons (Phil)
- Canada holiday updates (goodfore)
- Various inspection fixes
- Czech deprecation: replaced by Czechia (janpipek)

# Version 0.9.2

Released January 19, 2018

- Drop support for EOL Python 2.5, 2.6, 3.2 and 3.3 (hugovk)
- Add Finnish holidays (Ardetus)
- Add Slovak holidays (Filip Bednárik)

# Version 0.9.1

Released January 17, 2018

- Project moved to dr-prodigy
- Added tests for Irish calendar
- Minor fixes and refactoring

# Version 0.9

Released January 14, 2018 (PR merging by dr-prodigy)

- Add support for Python 3.6 (dr-prodigy)
- Add Italian holidays (dr-prodigy)
- Add Slovenian holidays (Cvetk0)
- Add South African holidays (nickyspag)
- Add Belgium holidays (fb22)
- Add French holidays (oiffrig)
- Add Japanese holidays (kokinomura)
- Add Polish holidays (tadeoos)
- Add Swedish holidays (johanpalmqvist)
- Add AU/Queensland The Ekka Show (kirpit)
- Various fixes

# Version 0.8.1

Released February 12, 2017

- Add Norwegian holidays

# Version 0.8

Released February 2, 2017

- Improve United Kingdom holidays
- Add England, Wales, Scotland
- Add Northern Ireland, Isle of Man
- Add Republic of Ireland
- Fix Liberation Day (NL)

# Version 0.7

Released January 12, 2017

- Add holidays, extended holidays and tests for Portugal
- Add holidays and tests for the Netherlands
- Specify encoding when parsing for version in setup.py allowing package to be installed in non-unicode locales

# Version 0.6

Released November 18, 2016

- Rename project from holidays.py to python-holidays
- PyPI location `holidays` remains the same
- Add Czech holidays
- Add UK special holidays
- Add ECB TARGET bank holidays
- Add changes to Georgia state holiday names for 2016
- Fixes to Canadian holidays

# Version 0.5

Released September 5, 2016

- Add support for Python 3.5
- Add holidays and tests for Columbia, Denmark, Spain, United Kingdom
- Fix Martin Luther King Jr. Day in state of Georgia
- Fix setup.py install error with non-standard sys default encoding

# Version 0.4.1

Released January 5, 2016

- Add federal and provincial holidays for Germany
- Add federal holidays for Austria

# Version 0.4

Released October 4, 2015

- Add `append` and `get_list` methods to Holiday objects
- Add federal and provincial holidays for Australia
- Add federal and provincial holidays for New Zealand
- Add state-specific holidays for all US states and territories
- Include Dec 31st from previous year when observed New Year's Day
- Add ability to `sum()` Holiday objects

# Version 0.3.1

Released October 9, 2014

- Fix pip installs when python-dateutil not already present

# Version 0.3

Released September 4, 2014

- Adds federal holidays for Mexico
- Holiday objects can now be combined with the addition operator (see examples in README)
- optional parameter `default` added to get() method to make it behave the same as dict.get()

# Version 0.2

Released August 28, 2014

- Each country is now initialized with its own individual class (see examples in README). This is a backward incompatible API change.
- Adds support for Python 3.2, 3.3, 3.4, and PyPy
- All code now conforms to PEP8 standards

# Version 0.1

Released August 1, 2014

- Initial release
- Support for Python 2.5, 2.6, 2.7
- Includes federal and provincial holidays for Canada, United States
