"""
Small script to check the log generated by a test run (either frozen or source).
"""

import os
import sys

# Locate the log
logfilename = os.path.abspath(os.path.join(__file__, "..", "..", "log.txt"))
if not os.path.isfile(logfilename):
    raise RuntimeError(f"Pyzo log file not found in {logfilename}")

# Read and clear the log
with open(logfilename, "rt") as f:
    log = f.read()
os.remove(logfilename)

# Print the log
print("=" * 80)
print(log)

# Examine the results
if any(x in log.lower() for x in ["exception", "uncaught", "error"]):
    sys.exit("Errors detected during Pyzo test run :(")
elif not log.strip().endswith("Stopped"):
    sys.exit("Unclean stop for Pyzo test run :(")
else:
    print("==> Pyzo test run looks OK :)")
    sys.exit(0)
