# new python file
import QCakeApi
import sys

class StdoutCatcher:
   def __init__(self):
      self.data = ''
   def write(self, stuff):
      self.data = self.data + stuff
      QCakeApi.debug(self.data)
      self.data = ''

sys.stdout = StdoutCatcher()
sys.stderr = StdoutCatcher()

class Vector:
    def __init__(self,x, y, z):
        self.x=x + 0.0
        self.y=y + 0.0
        self.z=z + 0.0
        
    def __add__(self, other):   # x + y   ->  x.__add__(y)
          return vector(self.x+other.x, self.y+other.y, self.z+other.z)

    def __iadd__(self, other):  # x += y  ->  x.__iadd__(y)
          self.x += other.x
          self.y += other.y
          self.z += other.z
          return self

    __radd__ = __add__          # x + y   ->  y.__radd__(x)
      
    def __sub__(self, other):   # x - y   ->  x.__sub__(y)
          return vector(self.x-other.x, self.y-other.y, self.z-other.z)
    
    def __isub__(self, other):  # x -= y  ->  x.__isub__(y)
          self.x -= other.x
          self.y -= other.y
          self.z -= other.z
          return self
    
    def __rsub__(self, other):   # x - y   ->  y.__sub__(x)
          return vector(-self.x+other.x, -self.y+other.y, -self.z+other.z)


      
    def add(self,b):
        self.x+=b.x + 0.0
        self.y+=b.y + 0.0
        self.z+=b.z + 0.0

    def sub(self,b):
        self.x-=b.x + 0.0
        self.y-=b.y + 0.0
        self.z-=b.z + 0.0

class QCO:
    def __init__(self,id):
        self.id = id
        self.ref = QCakeApi.getRef(self.id)

    def getattr(self,args):
        return QCakeApi.getAttribute(self.ref, args)

    def setattr(self,args):
        return QCakeApi.setAttribute(self.ref, args)

    def getpos(self):
        return Vector(QCakeApi.getPositionX(self.ref), QCakeApi.getPositionY(self.ref), QCakeApi.getPositionZ(self.ref))

    def getrot(self):
        return Vector(QCakeApi.getPositionH(self.ref), QCakeApi.getPositionP(self.ref), QCakeApi.getPositionR(self.ref))

    def setpos(self,v):
        return QCakeApi.setPosition(self.ref, v.x, v.y, v.z, QCakeApi.getPositionH(self.ref), QCakeApi.getPositionP(self.ref), QCakeApi.getPositionR(self.ref))

    def setrot(self,r):
        return QCakeApi.setPosition(self.ref, QCakeApi.getPositionX(self.ref), QCakeApi.getPositionY(self.ref), QCakeApi.getPositionZ(self.ref), r.x, r.y, r.z)

    def rotate(self,r):
        return QCakeApi.Rotate(self.ref, r.x, r.y, r.z)

    def move(self,v):
        return self.setpos(getpos(self.getpos().add(v)))

    def getpos_x(self):
        return QCakeApi.getPositionX(self.ref)

    def getpos_y(self):
        return QCakeApi.getPositionY(self.ref)

    def getpos_z(self):
        return QCakeApi.getPositionZ(self.ref)

    def getpos_h(self):
        return QCakeApi.getPositionH(self.ref)

    def getpos_p(self):
        return QCakeApi.getPositionP(self.ref)

    def getpos_r(self):
        return QCakeApi.getPositionR(self.ref)

    def setsequence(self,s,m):
        return QCakeApi.setSequence(self.ref, s, m)

    def Ref(self):
        return self.ref
