/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Nov  7 16:54:22 CET 2004
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   this program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QApplication>
#include <getopt.h>
#include "globdefines.h"
#include "mainwindow.hpp"
#include "astar.hpp"
#include "listviews.hpp"
#include <plib/ssg.h>
#include "qcakerun.h"
#include "messages.hpp"

// global variables !!!!
int g_mouse_mode=0;
int g_mouse_x=0;
int g_mouse_y=0;
int g_mouse_button=0;
sgVec3 g_poi; // point of interest
int g_window_w=0;
int g_window_h=0;
QSet<int> g_keyset;
int g_key=0;
int g_playmode=0;
int g_switch = 0;
long g_nextid=0;
bool g_debug= TRUE;

Glcontrol    *g_gl=NULL;
QString g_prjpath;
QString g_apppath;
QString g_editor;
// Catalog
QString g_3dcatalogpath;
QString g_scriptcatalogpath;
int g_3dcatalogkategorie=0;
QString g_soundcatalogpath;
QString g_shadercatalogpath;
QString g_physikcatalogpath;
// Display
int g_displayfps;
int g_displayphfps;

Messages *g_messages = NULL;

FolderListItem *g_tmpItem=NULL;
FolderListItem *g_switchScene = NULL;
// AStar
aStar *gastar= NULL;

void help(int ret)
{
    qWarning(" ");

    switch ( ret )
    {
       case 2:
       qWarning("Input-Output Error!\n\n");
       break;
    }

    qWarning("Usage: qcakeplayer [Options] filename.xml  \n");
    qWarning("	-f	start game in full screen mode");
    qWarning("	-w	display in a window (default)");
    qWarning("	-v	Version Info\n");
    exit(ret);
}


int main(int argc, char *argv[])
{
  int opt;
  int opt_fullscreen = 0;
  
  QApplication ap(argc, argv);

  g_apppath = QCoreApplication::applicationDirPath ();
 #ifdef    Q_OS_MACX
    g_apppath = ".";
 #endif
  qWarning(g_apppath.toAscii());

  while ( (opt = getopt(argc, argv, "+fwv")) != -1 ) {
     switch ( opt )
     {
         case 'f': {
                opt_fullscreen=1;
                break;
         }
         case 'w': {
                opt_fullscreen=0;
                break;
         }
         case 'v': {
                qWarning(QCAKEVERSION);
                help(1);
                break;
         }
         default:
         help(1);
    }
  }
  if ( argc <= 1 ) help(1);

  // SplahScreen
    QSplashScreen *splash = new QSplashScreen(QPixmap(":/images/qcake.png"));
    splash->setWindowFlags(splash->windowFlags() | Qt::WindowStaysOnTopHint);
    splash->show();
    splash->showMessage("Initialize QCake Player...", Qt::AlignRight | Qt::AlignTop, Qt::blue);
    QTimer::singleShot(2000, splash, SLOT(close()));

//  g_client = NULL;


  QcakeRunApp *qcakerun=new QcakeRunApp(&ap);

  g_gl = new Glcontrol( );

  if(argc>1){
    if(opt_fullscreen){
        g_gl->showFullScreen ();
    }else{
        g_gl->show();
    }
    qcakerun->openDocumentFile(argv[argc -1]);
    qcakerun->slotToolsPlay();
  }

  if (splash)
        delete splash;

  int result = ap.exec();

  // free memory

  if(g_gl)
      delete g_gl;
  if(gastar)
      delete gastar;

  return result;
}
