/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SUPPORTFUNCTIONS_H
#define SUPPORTFUNCTIONS_H

#include <QString>
#include <QLineEdit>
#include <QCheckBox>
#include <QComboBox>
#include <QButtonGroup>
#include <QSpinBox>
#include <QFileDialog>
#include <QRadioButton>
#include <QSlider>
#include <QPlainTextEdit>

/** \file */

#define OK TRUE
#define NOK FALSE
/** get int value from a QLinedit */ 
bool getValue(int &val, QLineEdit *input);
/** get double value from a QLinedit */ 
bool getValue(double &val, QLineEdit *input);
/** get int value from a QString */ 
bool getValue(int &val, QString input);
bool getValue(double &val, QString input);
void getValue(bool &val, QCheckBox *input);
void getValue(int &val, QSpinBox *input);
void getValue(QString &s, QLineEdit *input);
void getValue(QString &s, QPlainTextEdit *input);

void getValue(int &s, QComboBox *input);
void getIndex(int &s, QComboBox *input);
void getValue(QString &s, QComboBox *input);
void getValue(int &s, QButtonGroup *input);
void getValue(bool &val, QRadioButton *input);
void getValue(int &val, QSlider *input);

void setValue(int val, QLineEdit* output);
void setValue(double val, QLineEdit* output);
void setValue(double val, QLineEdit* output,int prec);
void setValue(bool val, QCheckBox *input);
void setValue(int val, QSpinBox *input);
void setValue(QString s, QLineEdit *input);
void setValue(int s, QComboBox *input);
void setIndex(int s, QComboBox *input);
void setValue(QString s, QComboBox *input);
void setValue(int s, QButtonGroup *input);
void setValue(bool val, QRadioButton *input);
void setValue(int val, QSlider *input);



bool browseGetFile(QLineEdit *le,QString deflt,const QString &filter="*");
bool browseSaveFile(QLineEdit *le,QString deflt,const QString &filter="*");
bool browseDir(QLineEdit *le,QString deflt,const QString &filter="*");

bool trash(QString filename,bool forceDelete);


class dirDialog : public QFileDialog
{
public:
	
	dirDialog(QWidget *parent=0, const char * name=0, bool modal= FALSE);
  ~dirDialog();
  QString openFileName(const QString & startWith, const QString &filter="*",bool single=TRUE);
  QString openDirName(const QString & startWith, const QString &filter="*");
	QString saveFileName(const QString & startWith, const QString &filter,QString extension);
};



#endif

