% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{read_tree_greengenes}
\alias{read_tree_greengenes}
\title{Read GreenGenes tree released in annotated newick format}
\usage{
read_tree_greengenes(treefile)
}
\arguments{
\item{treefile}{(Required). A character string implying 
a file \code{\link{connection}}
(like a path or URL), or an actual \code{\link{connection}}.
Must be a Newick--formatted tree released by GreenGenes
in October 2012 or later.
The similarity threshold of the OTUs should not matter,
except that it should match your OTU table.}
}
\value{
A tree, represented as a \code{\link{phylo}} object.
}
\description{
In principal, this is a standard newick format, that can be imported
into R using \code{\link{read_tree}},
which in-turn utilizes \code{\link[ape]{read.tree}}.
However, \code{\link[ape]{read.tree}} has failed to import
recent (October 2012 and later) releases of the GreenGenes tree,
and this problem has been traced to the additional annotations
added to some internal nodes 
that specify taxonomic classification between single-quotes. 
To solve this problem and create a clear container
for fixing future problems with the format of GreenGenes-released trees,
this function is available in phyloseq and exported for users.
It is also referenced in the documentation of the import functions
for QIIME legacy and BIOM format importers --
\code{\link{import_qiime}} and \code{\link{import_biom}}, respectively.
However, since the precise format of the tree is not restricted to GreenGenes trees
by QIIME or for the biom-format, this function is not called
automatically by those aforementioned import functions.
If your tree is formatted like, or is one of, the official GreenGenes
release trees, then you should use this function and provide its output
to your relevant import function.
}
\examples{
# Read the May 2013, 73\% similarity official tree,
# included as extra data in phyloseq.
treefile = system.file("extdata", "gg13-5-73.tree.gz", package="phyloseq")
x = read_tree_greengenes(treefile)
x
class(x)
y = read_tree(treefile)
y
class(y)
## Not run, causes an error:
# library("ape")
# read.tree(treefile)
}
