% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minorAllele.R
\name{minorAllele}
\alias{minorAllele}
\title{Compute minor allele frequency}
\usage{
minorAllele(x)
}
\arguments{
\item{x}{a \linkS4class{genind} object}
}
\description{
This function computes the minor allele frequency for each locus in a \linkS4class{genind} object. To test if loci are polymorphic, see the function  \code{\link{isPoly}}.
}
\examples{
\dontrun{

## LOAD DATA
data(nancycats)

## COMPUTE ALLELE FREQUENCIES
x <- nancycats
apply(tab(x, freq=TRUE),2,mean, na.rm=TRUE)

## GET MINOR ALLELE FREQUENCY
m.freq <- minorAllele(x)
m.freq
}

}
\seealso{
\code{\link{isPoly}}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
