% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_schedulers.R
\docType{data}
\name{scheduler-param}
\alias{scheduler-param}
\alias{rate_initial}
\alias{rate_largest}
\alias{rate_reduction}
\alias{rate_steps}
\alias{rate_step_size}
\alias{rate_decay}
\alias{rate_schedule}
\alias{values_scheduler}
\title{Parameters for neural network learning rate schedulers
These parameters are used for constructing neural network models.}
\format{
An object of class \code{character} of length 5.
}
\usage{
rate_initial(range = c(-3, -1), trans = log10_trans())

rate_largest(range = c(-1, -1/2), trans = log10_trans())

rate_reduction(range = c(1/5, 1), trans = NULL)

rate_steps(range = c(2, 10), trans = NULL)

rate_step_size(range = c(2, 20), trans = NULL)

rate_decay(range = c(0, 2), trans = NULL)

rate_schedule(values = values_scheduler)

values_scheduler
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{A character string of possible values. See \code{values_scheduler}
in examples below.}
}
\description{
Parameters for neural network learning rate schedulers
These parameters are used for constructing neural network models.
}
\details{
These parameters are often used with neural networks via
\code{parsnip::mlp(engine = "brulee")}.

The details for how the \pkg{brulee} schedulers change the rates:
\itemize{
\item \code{schedule_decay_time()}: \eqn{rate(epoch) = initial/(1 + decay \times epoch)}
\item \code{schedule_decay_expo()}: \eqn{rate(epoch) = initial\exp(-decay \times epoch)}
\item \code{schedule_step()}: \eqn{rate(epoch) = initial \times reduction^{floor(epoch / steps)}}
\item \code{schedule_cyclic()}: \eqn{cycle = floor( 1 + (epoch / 2 / step size) )},
\eqn{x = abs( ( epoch / step size ) - ( 2 * cycle) + 1 )}, and
\eqn{rate(epoch) = initial + ( largest - initial ) * \max( 0, 1 - x)}
}
}
\keyword{datasets}
