% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC-support.R
\name{as.mcmc.emmGrid}
\alias{as.mcmc.emmGrid}
\alias{mcmc-support}
\alias{as.mcmc.list.emmGrid}
\title{Support for MCMC-based estimation}
\usage{
\method{as.mcmc}{emmGrid}(x, names = TRUE, sep.chains = TRUE, likelihood,
  NE.include = FALSE, ...)

\method{as.mcmc.list}{emmGrid}(x, names = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{emmGrid}}

\item{names}{Logical scalar or vector specifying whether variable names are
appended to levels in the column labels for the \code{as.mcmc} or
\code{as.mcmc.list} result -- e.g., column names of \code{treat A} and
\code{treat B} versus  just \code{A} and \code{B}. When there is more than
one variable involved, the elements of \code{names} are used cyclically.}

\item{sep.chains}{Logical value. If \code{TRUE}, and there is more than one
MCMC chain available, an \code{\link[coda]{mcmc.list}} object is returned
by \code{as.mcmc}, with separate EMMs posteriors in each chain.}

\item{likelihood}{Character value or function. If given, simulations are made from 
the corresponding posterior predictive distribution. If not given, we obtain
the posterior distribution of the parameters in \code{object}. See Prediction
section below.}

\item{NE.include}{Logical value. If \code{TRUE}, non-estimable columns are
kept but returned as columns of \code{NA} values (this may create errors or
warnings in subsequent analyses using, say, \pkg{coda}). If \code{FALSE},
non-estimable columns are dropped, and a warning is issued. (If all are
non-estimable, an error is thrown.)}

\item{...}{arguments passed to other methods}
}
\value{
An object of class \code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}}.
}
\description{
When a model is fitted using Markov chain Monte Carlo (MCMC) methods, 
its reference grid contains a \code{post.beta} slot. These functions 
transform those posterior samples to posterior samples of EMMs or
related contrasts. They can then be summarized or plotted using,
e.g., functions in the \pkg{coda} package.
}
\section{Details}{

When the object's \code{post.beta} slot is non-trivial, \code{as.mcmc} will
return an \code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}} object
that can be summarized or plotted using methods in the \pkg{coda} package.
In these functions, \code{post.beta} is transformed by post-multiplying it by
\code{t(linfct)}, creating a sample from the posterior distribution of LS
means. In \code{as.mcmc}, if \code{sep.chains} is \code{TRUE} and there is in
fact more than one chain, an \code{mcmc.list} is returned with each chain's
results. The \code{as.mcmc.list} method is guaranteed to return an
\code{mcmc.list}, even if it comprises just one chain.
}

\section{Prediction}{

When \code{likelihood} is specified, it is used to simulate values from the
posterior predictive distribution corresponding to the given likelihood and
the posterior distribution of parameter values. Denote the likelihood 
function as \eqn{f(y|\theta,\phi)}, where \eqn{y} is a response, \eqn{\theta}
is the parameter estimated in \code{object}, and \eqn{\phi} comprises zero or
more additional parameters to be specified. If \code{likelihood} is a 
function, that function should take as its first argument a vector of 
\eqn{\theta} values (each corresponding to one row of \code{object@grid}).
Any \eqn{\phi} values should be specified as additional named function
arguments, and passed to \code{likelihood} via \code{...}. This function should 
simulate values of \eqn{y}.

A few standard likelihoods are available by specifying \code{likelihood} as
a character value. They are:
\describe{
  \item{\code{"normal"}}{The normal distribution with mean \eqn{\theta} and
  standard deviation specified by additional argument \code{sigma}}
  \item{\code{"binomial"}}{The binomial distribution with success probability 
    \eqn{theta}, and number of trials specified by \code{trials}}
  \item{\code{"poisson"}}{The Poisson distribution with mean \eqn{theta} 
    (no additional parameters)}
  \item{\code{"gamma"}}{The gamma distribution with scale parameter \eqn{\theta}
    and shape parameter specified by \code{shape}}
}
}

\examples{
if(requireNamespace("coda")) {
  ### A saved reference grid for a mixed logistic model (see lme4::cbpp)
  cbpp.rg <- do.call(emmobj, 
    readRDS(system.file("extdata", "cbpplist", package = "emmeans")))
  # Predictive distribution for herds of size 20
  # (perhaps a bias adjustment should be applied; see "sophisticated" vignette)
  pred.incidence <- coda::as.mcmc(regrid(cbpp.rg), likelihood = "binomial", trials = 20)
  summary(pred.incidence)
}
}
