% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{scenario.update.paths}
\alias{scenario.update.paths}
\title{Update filesystem paths of a scenario consistently.}
\usage{
scenario.update.paths(scenario, from, to, fixed = TRUE)
}
\arguments{
\item{scenario}{(\code{list()}) \cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link{defaultScenario}} or \code{\link{readScenario}}.}

\item{from}{character string containing a regular expression (or character
string for \code{fixed = TRUE}) to be matched.}

\item{to}{the replacement string.character string. For \code{fixed = FALSE}
this can include backreferences \code{"\1"} to \code{"\9"} to
parenthesized subexpressions of \code{from}.}

\item{fixed}{logical.  If \code{TRUE}, \code{from} is a string to be matched
as is.}
}
\value{
The updated scenario
}
\description{
This function should be used to change the filesystem paths stored in a
scenario object. Useful when moving a scenario from one computer to another.
}
\examples{
\dontrun{
scenario <- readScenario(filename = "scenario.txt")
scenario <- scenario.update.paths(scenario, from = "/home/manuel/", to = "/home/leslie")
}
}
\seealso{
\code{\link[base]{grep}}
}
