% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{irace_main}
\alias{irace_main}
\title{Higher-level interface to launch irace.}
\usage{
irace_main(scenario, output.width = 9999L)
}
\arguments{
\item{scenario}{\code{list()}\cr Data structure containing \pkg{irace}
settings. The data structure has to be the one returned by the function
\code{\link[=defaultScenario]{defaultScenario()}} or \code{\link[=readScenario]{readScenario()}}.}

\item{output.width}{\code{integer(1)}\cr The width used for the screen
output.}
}
\value{
(\code{invisible(data.frame)})

A data frame with the set of best algorithm configurations found by \pkg{irace}.
The data frame has the following columns:
\itemize{
\item \code{.ID.} : Internal id of the candidate configuration.
\item \verb{Parameter names} : One column per parameter name in \code{parameters}.
\item \code{.PARENT.} : Internal id of the parent candidate configuration.
}

Additionally, this function saves an R data file containing an object called
\code{iraceResults}. The path of the file is indicated in \code{scenario$logFile}.
The \code{iraceResults} object is a list with the following structure:

\describe{

\item{\code{scenario}}{The scenario R object containing the \pkg{irace}
options used for the execution. See \code{\link{defaultScenario}}
for more information. The element \code{scenario$parameters} contains the parameters R object that describes the target algorithm parameters. See
\code{\link{readParameters}}.}

\item{\code{allConfigurations}}{The target algorithm configurations
generated by \pkg{irace}. This object is a data frame, each row is a
candidate configuration, the first column (\code{.ID.}) indicates the
internal identifier of the configuration, the following columns
correspond to the parameter values, each column named as the parameter
name specified in the parameter object. The final column
(\code{.PARENT.})  is the identifier of the configuration from which
model the actual configuration was sampled.}

\item{\code{allElites}}{A list that contains one element per iteration,
each element contains the internal identifier of the elite candidate
configurations of the corresponding iteration (identifiers correspond to
\code{allConfigurations$.ID.}).}

\item{\code{iterationElites}}{A vector containing the best candidate
configuration internal identifier of each iteration. The best
configuration found corresponds to the last one of this vector.}

\item{\code{experiments}}{A matrix with configurations as columns and
instances as rows. Column names correspond to the internal identifier of
the configuration (\code{allConfigurations$.ID.}).}

\item{\code{experimen_log}}{A \code{data.table} with columns \code{iteration},
\code{instance}, \code{configuration}, \code{time}.  This matrix contains the log of all the
experiments that \pkg{irace} performs during its execution.  The
instance column refers to the index of the \code{race_state$instances_log}
data frame. Time is saved ONLY when reported by the \code{targetRunner}.}

\item{\code{softRestart}}{A logical vector that indicates if a soft
restart was performed on each iteration. If \code{FALSE}, then no soft
restart was performed.}

\item{\code{state}}{An environment that contains the state of \pkg{irace}, the
recovery is done using the information contained in this object.}

\item{\code{testing}}{A list that contains the testing results. The
elements of this list are: \code{experiments} a matrix with the testing
experiments of the selected configurations in the same format as the
explained above and \code{seeds} a vector with the seeds used to execute
each experiment.}

}
}
\description{
Higher-level interface to launch irace.
}
\details{
This function checks the correctness of the scenario, reads the
parameter space from \code{scenario$parameterFile}, invokes \code{\link[=irace]{irace()}},
prints its results in various formatted ways, (optionally) calls
\code{\link[=psRace]{psRace()}} and, finally, evaluates the best configurations on the test
instances (if provided). If you want a lower-level interface that just
runs irace, please see function \code{\link[=irace]{irace()}}.
}
\seealso{
\describe{
\item{\code{\link[=irace_cmdline]{irace_cmdline()}}}{a command-line interface to \code{\link[=irace]{irace()}}.}
\item{\code{\link[=readScenario]{readScenario()}}}{for reading a configuration scenario from a file.}
\item{\code{\link[=readParameters]{readParameters()}}}{read the target algorithm parameters from a file.}
\item{\code{\link[=defaultScenario]{defaultScenario()}}}{returns the default scenario settings of \pkg{irace}.}
}
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
\concept{running}
