% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{importMsd}
\alias{importMsd}
\title{Import MSD files}
\usage{
importMsd(path, ...)
}
\arguments{
\item{path}{\code{character}, path to directory or file which should be read
in.}

\item{\ldots}{arguments to be passed to
\code{\link[MALDIquantForeign]{import}}.}
}
\value{
a \code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects (depending on the
\code{centroided} argument).
}
\description{
This function imports files in mMass MSD file format
into \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects.
}
\examples{

library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file("exampledata", package="MALDIquantForeign")

## import
s <- importMsd(exampleDirectory)

}
\references{
\url{http://strimmerlab.org/software/maldiquant/}, \cr
mMass homepage: \url{http://mmass.org/}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}},
\code{\link[MALDIquant]{MassPeaks-class}}
}
\author{
Sebastian Gibb
}
