% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableConnections.R
\name{availableConnections}
\alias{availableConnections}
\alias{freeConnections}
\title{Number of Available and Free Connections}
\usage{
availableConnections()

freeConnections()
}
\value{
A non-negative integer, or \code{+Inf} if the available number of connections
is greated than 16384, which is a limit be set via option
\option{parallelly.availableConnections.tries}.
}
\description{
The number of \link{connections} that can be open at the same time in \R is
\emph{typically} 128, where the first three are occupied by the always open
\code{\link[=stdin]{stdin()}}, \code{\link[=stdout]{stdout()}}, and \code{\link[=stderr]{stderr()}} connections, which leaves 125 slots
available for other types of connections.  Connections are used in many
places, e.g. reading and writing to file, downloading URLs, communicating
with parallel \R processes over a socket connections, and capturing standard
output via text connections.
}
\section{How to increase the limit}{

This limit of 128 connections can only be changed by rebuilding \R from
source.  The limited is hardcoded as a\if{html}{\out{<div class="sourceCode c">}}\preformatted{#define NCONNECTIONS 128
}\if{html}{\out{</div>}}

in \file{src/main/connections.c}.
}

\section{How the limit is identified}{

Since the limit \emph{might} changed, for instance in custom \R builds or in
future releases of \R, we do not want to assume that the limit is 128 for
all \R installation.  Unfortunately, it is not possible to query \R for what
the limit is.
Instead, \code{availableConnections()} infers it from trial-and-error.
until it fails.  For efficiency, the result is memoized throughout the
current \R session.
}

\examples{
total <- availableConnections()
message("You can have ", total, " connections open in this R installation")
free <- freeConnections()
message("There are ", free, " connections remaining")

}
\references{
\enumerate{
\item 'WISH: Increase limit of maximum number of open connections (currently 125+3)', 2016-07-09,
\url{https://github.com/HenrikBengtsson/Wishlist-for-R/issues/28}
}
}
\seealso{
\code{\link[base:showConnections]{base::showConnections()}}.
}
