% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-package.R
\docType{package}
\name{posterior-package}
\alias{posterior-package}
\alias{posterior}
\title{Tools for working with posterior (and prior) distributions}
\description{
\if{html}{
   \figure{stanlogo.png}{options: width="50"}
   \url{https://mc-stan.org/posterior/}
}

The \pkg{posterior} package is intended to provide useful tools
for both users and developers of packages for fitting Bayesian models or
working with output from Bayesian models. The primary goals of the package
are to:
\itemize{
\item Efficiently convert between many different useful formats of
draws (samples) from posterior or prior distributions.
\item Provide consistent methods for operations commonly performed on draws,
for example, subsetting, binding, or mutating draws.
\item Provide various summaries of draws in convenient formats.
\item Provide lightweight implementations of state of the art posterior inference
diagnostics.
}
}
\section{Package options}{


The following options are used to format and print \code{\link{draws}} objects,
as in \code{print.draws_array()}, \code{print.draws_df()}, \code{print.draws_list()},
\code{print.draws_matrix()}, and \code{print.draws_rvars()}:
\itemize{
\item \code{posterior.max_draws}: Maximum number of draws to print.
\item \code{posterior.max_iterations}: Maximum number of iterations to print.
\item \code{posterior.max_chains}: Maximum number of chains to print.
\item \code{posterior.max_variables}: Maximum number of variables to print.
}

The following option is used to format and print \code{\link{rvar}} objects,
as in \code{print.rvar()} and \code{print.draws_rvars()}:
\itemize{
\item \code{posterior.rvar_summary}: What style of summary to display:
\code{"mean_sd"} displays \verb{mean±sd}, \code{"median_mad"} displays \verb{median±mad}.
}

The following option is used to construct new \code{\link{rvar}} objects,
as in \code{rfun()} and \code{rdo()}:
\itemize{
\item \code{posterior.rvar_ndraws}: The number of draws used to construct
new random variables when this number cannot be determined
from existing arguments (e.g., other \code{\link{rvar}}s passed to a function).
}

The following options are used to control warning messages:
\itemize{
\item \code{posterior.warn_on_merge_chains}: (logical) Some operations will
trigger an automatic merging of chains, for example, because chains do not
match between two objects involved in a binary operation. Whether this
causes a warning can be controlled by this option.
}
}

