% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_draws.R
\name{weight_draws}
\alias{weight_draws}
\alias{weight_draws.draws_matrix}
\alias{weight_draws.draws_array}
\alias{weight_draws.draws_df}
\alias{weight_draws.draws_list}
\alias{weight_draws.draws_rvars}
\title{Weight \code{draws} objects}
\usage{
weight_draws(x, weights, ...)

\method{weight_draws}{draws_matrix}(x, weights, log = FALSE, ...)

\method{weight_draws}{draws_array}(x, weights, log = FALSE, ...)

\method{weight_draws}{draws_df}(x, weights, log = FALSE, ...)

\method{weight_draws}{draws_list}(x, weights, log = FALSE, ...)

\method{weight_draws}{draws_rvars}(x, weights, log = FALSE, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{weights}{(numeric vector) A vector of weights of length \code{ndraws(x)}.
Weights will be internally stored on the log scale (in a variable called
\code{.log_weight}) and will not be normalized, but normalized (non-log) weights
can be returned via the \code{\link[=weights.draws]{weights.draws()}} method later.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{log}{(logicla) Are the weights passed already on the log scale? The
default is \code{FALSE}, that is, expecting \code{weights} to be on the standard
(non-log) scale.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Add weights to \code{\link{draws}} objects, with one weight per draw, for use in
subsequent weighting operations. For reasons of numerical accuracy, weights
are stored in the form of unnormalized log-weights (in a variable called
\code{.log_weight}). See \code{\link[=weights.draws]{weights.draws()}} for details how to extract weights from
\code{draws} objects.
}
\examples{
x <- example_draws()

# sample some random weights for illustration
wts <- rexp(ndraws(x))
head(wts)

# add weights
x <- weight_draws(x, weights = wts)

# extract weights
head(weights(x)) # defaults to normalized weights
head(weights(x, normalize=FALSE)) # recover original weights
head(weights(x, log=TRUE)) # get normalized log-weights

# add weights which are already on the log scale
log_wts <- log(wts)
head(log_wts)

x <- weight_draws(x, weights = log_wts, log = TRUE)
# extract weights
head(weights(x))
head(weights(x, log=TRUE, normalize = FALSE)) # recover original log_wts

}
\seealso{
\code{\link[=weights.draws]{weights.draws()}}, \code{\link[=resample_draws]{resample_draws()}}
}
