test_that("charToBib works ok", {

    ## Rcore <- format(citation(), style = "bibtex")
    ## ## add a citation key
    ## Rcore <- sub("\\@Manual\\{", "\\@Manual{Rcore", Rcore)
    ## cat(Rcore, sep = "\n")
    ## beRcore <- charToBib(Rcore)
    ## beRcore
    ## class(beRcore)
    ## print(beRcore, style = "R")

    ## Rcore is a bibtex string, without cite key. 
    bibRcore <- toBibtex(citation())
    be1 <- charToBib(bibRcore)
    be2 <- charToBib(bibRcore, direct = TRUE)
    ## some fields are renamed or dropped when direct is FALSE
    expect_equal(be1$publisher, be2$organization) # "R Foundation for Statistical Computing"
    
    ## with cite key
    txtRcore1 <- c(  
        "@Manual{Rcore,",                                                      
        "  title = {R: A Language and Environment for Statistical Computing},",
        "  author = {{R Core Team}},",
        "  organization = {R Foundation for Statistical Computing},",
        "  address = {Vienna, Austria},",
        "  year = {2020},",
        "  url = {https://www.R-project.org/},",
        "}" )

    txtRcore2 <- paste0(txtRcore1, collapse = " ")

    beRcore1 <- charToBib(txtRcore1)
    beRcore2 <- charToBib(txtRcore2)
    expect_equal(beRcore1, beRcore2)

    fn <- tempfile(fileext = ".bib")
    on.exit(unlink(fn))
    charToBib(txtRcore1, informat = "bibtex", outfile = fn)

    ## bibtex entries generated by citation() don't have cite keys.
    ## this sets the key to 'Rcore'
    beRcore <- charToBib(toBibtex(citation()), key = "Rcore")
    expect_equal(beRcore$key, "Rcore")

    ## this sets two keys
    bemore <- charToBib(toBibtex( c(citation(), citation("rbibutils"))),
                        key = c("Rcore", "Rpackage:rbibutils"))
    expect_equal(names(bemore), c("Rcore", "Rpackage:rbibutils"))

    
    bibdir <- system.file("bib", package = "rbibutils")
    fn2  <- file.path(bibdir, "litprog280no_macros.bib")
    mac <- file.path(bibdir, "litprog280macros_only.bib")

    withmac <- readBib(fn2, direct = TRUE, macros = mac)
    womac <- readBib(fn2, direct = TRUE)
    expect_equal(withmac["Racine:2012:RPI"]$key, "Racine:2012:RPI")  # keys are equal
    expect_equal(  womac["Racine:2012:RPI"]$key, "Racine:2012:RPI")
    ## withmac expands the @STRING for journal, otherwise not
    expect_equal(withmac["Racine:2012:RPI"]$journal, "Journal of Applied Econometrics" )
    expect_equal(  womac["Racine:2012:RPI"]$journal, "j-J-APPL-ECONOMETRICS" )

    charbib <- readLines(file.path(bibdir, "Rcore_with_abbr.bib"))
    withmac2 <- charToBib(charbib, direct = TRUE, macros = file.path(bibdir, "urlR.bib"))
    womac2 <- charToBib(charbib, direct = TRUE)
    expect_equal(withmac2["Rcore"]$key, "Rcore")  # keys are equal
    expect_equal(  womac2["Rcore"]$key, "Rcore")
    ## withmac expands the @STRING for journal, otherwise not
    expect_equal(withmac2["Rcore"]$url,  "https://www.R-project.org/" )
    expect_equal(  womac2["Rcore"]$url, "urlR" )  # not expanded

})

