% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_last_updates.R
\name{rdb_last_updates}
\alias{rdb_last_updates}
\title{Download informations about the last DBnomics updates.}
\usage{
rdb_last_updates(
  all = FALSE,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config")
)
}
\arguments{
\item{all}{Logical (default \code{FALSE}). If \code{TRUE}, then the full
dataset of the last updates is retrieved.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Named list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. A temporary \code{curl_handle} object is created internally
with arguments equal to the provided list in \code{curl_config}.\cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}
}
\value{
A \code{data.table}.
}
\description{
\code{rdb_last_updates} downloads informations about the last updates from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a \code{data.table}
containing the last 100 updates from
\href{https://db.nomics.world/}{DBnomics} with additional informations.
}
\examples{
\dontrun{
rdb_last_updates()

rdb_last_updates(all = TRUE)

rdb_last_updates(use_readLines = TRUE)

rdb_last_updates(curl_config = list(proxy = "<proxy>", proxyport = <port>))
}
}
\seealso{
\code{\link{rdb_providers}}
}
\author{
Sebastien Galais
}
