% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studies.R
\name{studies_find_trees}
\alias{studies_find_trees}
\title{Find Trees}
\usage{
studies_find_trees(
  property = NULL,
  value = NULL,
  verbose = FALSE,
  exact = FALSE,
  detailed = TRUE,
  ...
)
}
\arguments{
\item{property}{The property to be searched on (character)}

\item{value}{The property-value to be searched on (character)}

\item{verbose}{Should the output include all metadata? (logical,
default \code{FALSE})}

\item{exact}{Should exact matching be used for the value?
(logical, default \code{FALSE})}

\item{detailed}{Should a detailed report be provided? If
\code{TRUE} (default), the output will include metadata about
the study that include trees matching the property. Otherwise,
only information about the trees will be provided.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
A data frame that summarizes the trees found (and their
    associated studies) for the requested criteria. If a study has
    more than 5 trees, the \code{tree_ids} of the first ones will
    be shown, followed by \code{...} to indicate that more are
    present.

    If \code{detailed=FALSE}, the data frame will include the
    study ids of the study (\code{study_ids}), the number of trees
    in this study that match the search criteria
    (\code{n_matched_trees}), the tree ids that match the search
    criteria (\code{match_tree_ids}).

    If \code{detailed=TRUE}, in addition of the fields listed
    above, the data frame will also contain the total number of
    trees associated with the study (\code{n_trees}), all the tree
    ids associated with the study (\code{tree_ids}), the tree id
    that is a potential candidate for inclusion in the synthetic
    tree (if any) (\code{candidate}), the year the study was
    published (\code{study_year}), the title of the study
    (\code{title}), the DOI for the study (\code{study_doi}).
}
\description{
Return a list of studies for which trees match a given set of
properties
}
\details{
The list of possible values to be used as values for the argument
\code{property} can be found using the function
\code{\link{studies_properties}}.
}
\examples{
\dontrun{
res <- studies_find_trees(property="ot:ottTaxonName", value="Drosophilia",
                          detailed=FALSE)
## summary of the trees and associated studies that match this criterion
res
## With metadata about the studies (default)
res <- studies_find_trees(property="ot:ottTaxonName", value="Drosophilia",
                          detailed=TRUE)
## The list of trees for each study that match the search criteria
list_trees(res)
## the trees for a given study
list_trees(res, study_id = "pg_2769")
}
}
\seealso{
\code{\link{studies_properties}} which lists properties
  the studies can be searched on. \code{\link{list_trees}} for
  listing the trees that match the query.
}
