% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/graph.R
\name{as.Graph}
\alias{as.Graph}
\alias{as.Graph.Matrix}
\alias{as.Graph.matrix}
\alias{as.Graph.Neighbor}
\title{Coerce to a \code{Graph} Object}
\usage{
as.Graph(x, ...)

\method{as.Graph}{Matrix}(x, ...)

\method{as.Graph}{matrix}(x, ...)

\method{as.Graph}{Neighbor}(x, weighted = TRUE, ...)
}
\arguments{
\item{x}{The matrix to convert}

\item{...}{Ignored}

\item{weighted}{If TRUE, fill entries in Graph matrix with value from the
nn.dist slot of the Neighbor object}
}
\value{
A \code{\link{Graph}} object
}
\description{
Convert a \code{\link[base]{matrix}} (or \code{\link[Matrix]{Matrix}}) to
a \code{\link{Graph}} object
}
\examples{
# converting sparse matrix
mat <- Matrix::rsparsematrix(nrow = 10, ncol = 10, density = 0.1)
rownames(x = mat) <- paste0("feature_", 1:10)
colnames(x = mat) <- paste0("cell_", 1:10)
g <- as.Graph(x = mat)

# converting dense matrix
mat <- matrix(data = 1:16, nrow = 4)
rownames(x = mat) <- paste0("feature_", 1:4)
colnames(x = mat) <- paste0("cell_", 1:4)
g <- as.Graph(x = mat)

}
\seealso{
Other graph: 
\code{\link{Graph-class}}
}
\concept{graph}
