% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert-ui.R
\name{removeUI}
\alias{removeUI}
\title{Remove UI objects}
\usage{
removeUI(selector, multiple = FALSE, immediate = FALSE,
  session = getDefaultReactiveDomain())
}
\arguments{
\item{selector}{A string that is accepted by jQuery's selector (i.e. the
string \code{s} to be placed in a \code{$(s)} jQuery call). This selector
will determine the element(s) to be removed. If you want to remove a
Shiny input or output, note that many of these are wrapped in \code{div}s,
so you may need to use a somewhat complex selector -- see the Examples below.
(Alternatively, you could also wrap the inputs/outputs that you want to be
able to remove easily in a \code{div} with an id.)}

\item{multiple}{In case your selector matches more than one element,
\code{multiple} determines whether Shiny should remove all the matched
elements or just the first matched element (default).}

\item{immediate}{Whether the element(s) should be immediately removed from
the app when you call \code{removeUI}, or whether Shiny should wait until
all outputs have been updated and all observers have been run (default).}

\item{session}{The shiny session within which to call \code{removeUI}.}
}
\description{
Remove a UI object from the app.
}
\details{
This function allows you to remove any part of your UI. Once \code{removeUI}
is executed on some element, it is gone forever.

While it may be a particularly useful pattern to pair this with
\code{\link{insertUI}} (to remove some UI you had previously inserted),
there is no restriction on what you can use \code{removeUI} on. Any
element that can be selected through a jQuery selector can be removed
through this function.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
# Define UI
ui <- fluidPage(
  actionButton("rmv", "Remove UI"),
  textInput("txt", "This is no longer useful")
)

# Server logic
server <- function(input, output, session) {
  observeEvent(input$rmv, {
    removeUI(
      selector = "div:has(> #txt)"
    )
  })
}

# Complete app with UI and server components
shinyApp(ui, server)
}
}
\seealso{
\code{\link{insertUI}}
}
