% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_character.R
\name{sparse_character}
\alias{sparse_character}
\title{Create sparse character vector}
\usage{
sparse_character(values, positions, length, default = "")
}
\arguments{
\item{values}{integer vector, values of non-zero entries.}

\item{positions}{integer vector, indices of non-zero entries.}

\item{length}{integer value, Length of vector.}

\item{default}{integer value, value at indices not specified by \code{positions}.
Defaults to \code{""}. Cannot be \code{NA}.}
}
\value{
sparse character vector
}
\description{
Construction of vectors where only values and positions are recorded. The
Length and default values determine all other information.
}
\details{
\code{values} and \code{positions} are expected to be the same length, and are allowed
to both have zero length.

Allowed values for \code{value} are character values. Missing values such as \code{NA}
and \code{NA_real_} are allowed as they are turned into \code{NA_character_}.
Everything else is disallowed. The values are also not allowed to take the
same value as \code{default}.

\code{positions} should be integers or integer-like doubles. Everything else is
not allowed. Positions should furthermore be positive (\code{0} not allowed),
unique, and in increasing order. Lastly they should all be smaller that
\code{length}.

For developers:

setting \code{options("sparsevctrs.verbose_materialize" = TRUE)} will print a
message each time a sparse vector has been forced to materialize.
}
\examples{
sparse_character(character(), integer(), 10)

sparse_character(c("A", "C", "E"), c(2, 5, 10), 10)

str(
  sparse_character(c("A", "C", "E"), c(2, 5, 10), 1000000000)
)
}
\seealso{
\code{\link[=sparse_double]{sparse_double()}} \code{\link[=sparse_integer]{sparse_integer()}}
}
