% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse.R
\name{stri_reverse}
\alias{stri_reverse}
\title{Reverse Each String}
\usage{
stri_reverse(str)
}
\arguments{
\item{str}{character vector}
}
\value{
Returns a character vector.
}
\description{
Reverses the order of the code points in every string.
}
\details{
Note that this operation may result in non-Unicode-normalized
strings and may give peculiar outputs for bidirectional strings.

See also \code{\link{stri_rand_shuffle}} for a random permutation
of code points.
}
\examples{
stri_reverse(c('123', 'abc d e f'))
stri_reverse('ZXY (\u0105\u0104123$^).')
stri_reverse(stri_trans_nfd('\u0105')) == stri_trans_nfd('\u0105') # A, ogonek -> agonek, A

}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

}
