% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.ten}
\title{predicted events}
\usage{
\method{predict}{ten}(object, ..., eMP = TRUE, reCalc = FALSE)
}
\arguments{
\item{object}{An object of class \code{ten}.}

\item{...}{Additional arguments (not implemented).}

\item{eMP}{Add column(s) indicating
\bold{e}vents \bold{m}inus \bold{p}redicted.}

\item{reCalc}{Recalcuate the values?
 \cr
If \code{reCalc=FALSE} (the default) and the \code{ten} object already has
the calculated values stored as an \code{attribute},
the value of the \code{attribute} is returned directly.}
}
\value{
An \code{attribute}, \code{pred} is added
to \code{object}:
 \item{t}{Times with at least one observation}
 \item{P_}{\bold{p}redicted number of events}
And if \code{eMP==TRUE} (the default):
 \item{eMP_}{\bold{e}vents \bold{m}inus \bold{p}redicted}
The names of the \code{object}'s covariate groups are
used to make the suffixes of the column names (i.e. after the
\code{_} character).
}
\description{
predicted events
}
\details{
With \eqn{K} covariate groups, We use \eqn{ncg_{ik}}{ncg[i, k]},
the number at risk for group \eqn{k},
to calculate the number of expected events:
 \deqn{P_{ik} = \frac{e_i(ncg_{ik})}{n_i} \quad k=1, 2 \ldots K}{
       P[i, k] = e[i] * ncg[i, k] / n[i]}
}
\note{
There is a predicted value for each unique time, for each covariate group.
}
\examples{
## K&M. Example 7.2, Table 7.2, pp 209-210.
data("kidney", package="KMsurv")
k1 <- ten(Surv(time=time, event=delta) ~ type, data=kidney)
predict(k1)
predict(asWide(k1))
stopifnot(predict(asWide(k1))[, sum(eMP_1 + eMP_2)] <=
          .Machine$double.neg.eps)
## Three covariate groups
## K&M. Example 7.4, pp 212-214.
data("bmt", package="KMsurv")
b1 <- ten(Surv(time=t2, event=d3) ~ group, data=bmt)
predict(b1)
## one group only
predict(ten(Surv(time=t2, event=d3) ~ 1, data=bmt))

}
\seealso{
?survival::predict.coxph
methods("predict")
}
