% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSP.R
\name{TSP}
\alias{TSP}
\alias{as.TSP}
\alias{as.TSP.dist}
\alias{as.TSP.matrix}
\alias{as.dist.TSP}
\alias{print.TSP}
\alias{n_of_cities}
\alias{n_of_cities.TSP}
\alias{labels.TSP}
\alias{image.TSP}
\title{Class TSP -- Symmetric traveling salesperson problem}
\usage{
TSP(x, labels = NULL, method = NULL)

as.TSP(x)

\method{as.TSP}{dist}(x)

\method{as.TSP}{matrix}(x)

\method{as.dist}{TSP}(m, ...)

\method{print}{TSP}(x, ...)

n_of_cities(x)

\method{n_of_cities}{TSP}(x)

\method{labels}{TSP}(object, ...)

\method{image}{TSP}(x, order, col = gray.colors(64), ...)
}
\arguments{
\item{x, object}{an object (currently \code{dist} or a symmetric matrix) to
be converted into a \code{TSP} or, for the methods, an object of class
\code{TSP}.}

\item{labels}{optional city labels. If not given, labels are taken from
\code{x}.}

\item{method}{optional name of the distance metric. If \code{x} is a
\code{dist} object, then the method is taken from that object.}

\item{m}{a TSP object to be converted to a \link{dist} object.}

\item{...}{further arguments are passed on.}

\item{order}{order of cities for the image as an integer vector or an object
of class \link{TOUR}.}

\item{col}{color scheme for image.}
}
\value{
\itemize{
\item \code{TSP()} returns \code{x} as an object of class \code{TSP}.
\item \code{n_of_cities()} returns the number of cities in \code{x}.
\item \code{labels()} returns a vector with the names of the cities in \code{x}.
}
}
\description{
Constructor to create an instance of a symmetric traveling salesperson
problem (TSP) and some auxiliary methods.
}
\details{
Objects of class \code{TSP} are internally represented as \code{dist}
objects (use \code{\link[=as.dist]{as.dist()}} to get the \code{dist} object).
}
\examples{
data("iris")
d <- dist(iris[-5])

## create a TSP
tsp <- TSP(d)
tsp

## use some methods
n_of_cities(tsp)
labels(tsp)
image(tsp)
}
\seealso{
Other TSP: 
\code{\link{ATSP}()},
\code{\link{Concorde}},
\code{\link{ETSP}()},
\code{\link{TSPLIB}},
\code{\link{insert_dummy}()},
\code{\link{reformulate_ATSP_as_TSP}()},
\code{\link{solve_TSP}()}
}
\author{
Michael Hahsler
}
\concept{TSP}
\keyword{classes}
