% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_states.R
\name{tween_states}
\alias{tween_states}
\title{Tween a list of data.frames representing states}
\usage{
tween_states(data, tweenlength, statelength, ease, nframes)
}
\arguments{
\item{data}{A list of data.frames. Each data.frame must contain the same
number of rows, but only the first data.frame needs to contain all columns.
Subsequent data.frames need only contain the columns that shows change.}

\item{tweenlength}{The lengths of the transitions between each state.}

\item{statelength}{The length of the pause at each state.}

\item{ease}{The easing functions to use for the transitions. See details.}

\item{nframes}{The number of frames to generate. The actual number of frames
might end up being higher depending on the regularity of \code{tweenlength}
and \code{statelength}.}
}
\value{
A data.frame with the same columns as the first data.frame in
\code{data}, but replicated \code{nframes} times. An additional column called
\code{.frame} will be added giving the frame number.
}
\description{
This function is intended to create smooth transitions between states of
data. States are defined as full data.frames or data.frames containing only
the columns with change. Each state can have a defined period of pause, the
transition length between each states can be defined as well as the easing
function.
}
\examples{
data1 <- data.frame(
  x = 1:20,
  y = 0,
  colour = 'forestgreen',
  stringsAsFactors = FALSE
)
data2 <- data1
data2$x <- 20:1
data2$y <- 1

data <- tween_states(list(data1, data2), 3, 1, 'cubic-in-out', 100)

}
\seealso{
Other data.frame tween: \code{\link{tween_along}},
  \code{\link{tween_appear}},
  \code{\link{tween_components}},
  \code{\link{tween_elements}}, \code{\link{tween_events}}
}
\concept{data.frame tween}
